/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.api.common.Args;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.EntityParserSettings;
import com.univocity.parsers.common.EntitySettings;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class EntityList<E extends EntitySettings>
implements Iterable<E> {
    protected Map<String, E> entities = new TreeMap<String, E>();
    protected Map<String, String> originalEntityNames = new TreeMap<String, String>();
    private EntityParserSettings globalSettings;

    protected EntityList(EntityParserSettings globalSettings) {
        Args.notNull((Object)globalSettings, (String)"Parser settings");
        this.globalSettings = globalSettings;
    }

    public final E configureEntity(String entityName) {
        return this.configureEntity(entityName, null);
    }

    protected E configureEntity(String entityName, E parentEntity) {
        Args.notBlank((CharSequence)entityName, (String)"Entity name");
        String normalizedEntityName = entityName.trim().toLowerCase();
        if (this.entities.get(normalizedEntityName) == null) {
            E newEntity = this.newEntity(entityName, parentEntity);
            ((EntitySettings)newEntity).setParent(this);
            this.entities.put(normalizedEntityName, newEntity);
            this.originalEntityNames.put(entityName, normalizedEntityName);
        }
        EntitySettings entitySettings = (EntitySettings)this.entities.get(normalizedEntityName);
        entitySettings.setParent(this);
        return (E)entitySettings;
    }

    protected abstract E newEntity(String var1, E var2);

    public final Set<String> getEntityNames() {
        return new TreeSet<String>(this.originalEntityNames.keySet());
    }

    public final Collection<E> getEntities() {
        return Collections.unmodifiableCollection(this.entities.values());
    }

    public final E getEntity(String entityName) {
        ArgumentUtils.notEmpty((String)"Entity name", (Object[])new String[]{entityName});
        return (E)((EntitySettings)this.entities.get(entityName.trim().toLowerCase()));
    }

    public final void removeEntity(String entityName) {
        Args.notBlank((CharSequence)entityName, (String)"Entity name");
        entityName = entityName.trim().toLowerCase();
        this.entities.remove(entityName);
        this.originalEntityNames.remove(entityName);
    }

    public final void removeEntity(E entity) {
        Args.notNull(entity, (String)"Entity");
        this.removeEntity(((EntitySettings)entity).getEntityName());
    }

    @Override
    public final Iterator<E> iterator() {
        return this.entities.values().iterator();
    }

    protected E addEntitySettings(E settings) {
        Args.notNull(settings, (String)"Entity settings");
        String entityName = ((EntitySettings)settings).getEntityName();
        this.configureEntity(entityName);
        String normalizedEntityName = entityName.trim().toLowerCase();
        Object config = ((EntitySettings)settings).clone();
        this.entities.put(normalizedEntityName, config);
        ((EntitySettings)config).setParent(this);
        return (E)config;
    }

    public EntityParserSettings getParserSettings() {
        return this.globalSettings;
    }

    protected abstract EntityList newInstance();
}

