package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DiagnosticEventRepository
import com.unity3d.ads.core.domain.events.GetDiagnosticEventRequest

internal class AndroidSendDiagnosticEvent(
    private val diagnosticEventRepository: DiagnosticEventRepository,
    private val getDiagnosticEventRequest: GetDiagnosticEventRequest,
) : SendDiagnosticEvent {
    override operator fun invoke(
        event: String,
        value: Double?,
        tags: Map<String, String>?,
        intTags: Map<String, Int>?
    ) {
        val diagnosticEventRequest = getDiagnosticEventRequest(event, tags, intTags, value)
        diagnosticEventRepository.addDiagnosticEvent(diagnosticEventRequest)
    }
}