package com.unity3d.ads.core.extensions

import com.unity3d.ads.UnityAds.UnityAdsLoadError
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_INIT_FAILED
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_INTERNAL
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_INVALID
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_NO_FILL
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.REASON_TIMEOUT

fun UnityAdsLoadError.toDiagnosticReason(): String {
    return when (this) {
        UnityAdsLoadError.INITIALIZE_FAILED -> REASON_INIT_FAILED
        UnityAdsLoadError.INTERNAL_ERROR -> REASON_INTERNAL
        UnityAdsLoadError.INVALID_ARGUMENT -> REASON_INVALID
        UnityAdsLoadError.NO_FILL -> REASON_NO_FILL
        UnityAdsLoadError.TIMEOUT -> REASON_TIMEOUT
    }
}