package com.unity3d.ads.core.domain

interface SendDiagnosticEvent {
    suspend operator fun invoke(event: String, value: Long? = null, tags: Map<String, String>? = null, intTags: Map<String, Int>? = null)

    companion object {
        // initialize
        const val INIT_STARTED = "native_initialization_started"
        const val INIT_SUCCESS = "native_initialize_task_success_time"
        const val INIT_FAILURE = "native_initialize_task_failure_time"
        // load
        const val LOAD_STARTED = "native_load_started"
        const val LOAD_SUCCESS = "native_load_success_time"
        const val LOAD_FAILURE = "native_load_failure_time"
        const val LOAD_TIMEOUT = "native_load_timeout"
        // show
        const val SHOW_STARTED = "native_show_started"
        const val SHOW_CANCEL_TIMEOUT = "native_show_cancel_timeout"
        const val SHOW_WV_STARTED = "native_show_wv_started"
        const val SHOW_SUCCESS = "native_show_success_time"
        const val SHOW_FAILURE = "native_show_failure_time"
        const val SHOW_CLICKED = "native_show_clicked"
        // network
        const val NETWORK_SUCCESS = "native_network_success_time"
        const val NETWORK_FAILURE = "native_network_failure_time"
        // webview
        const val WEBVIEW_ERROR = "webview_error"
        // system
        const val SYSTEM_CRONET_SUCCESS = "native_cronet_success_time"
        const val SYSTEM_CRONET_FAILURE = "native_cronet_failure_time"
        // tags
        const val AD_LOAD_TYPE: String = "type"
        const val UNKNOWN = "unknown"
        const val REASON = "reason"
        const val WEBVIEW_URL = "webview_url"
        const val WEBVIEW_ERROR_CODE = "webview_error_code"
        const val OPERATION = "operation"
        const val RETRIES = "retries"
        const val PROTOCOL = "protocol"
        const val NETWORK_CLIENT = "network_client"
        // AdViewer
        const val BRIDGE_SEND_EVENT_FAILED = "bridge_send_event_failed"
        // Reason
        const val REASON_UNKNOWN = "unknown"
        const val REASON_TIMEOUT = "timeout"
        const val REASON_NO_FILL = "no_fill"
        const val REASON_INTERNAL = "internal"
        const val REASON_NETWORK = "network"
        const val REASON_GATEWAY = "gateway"
        const val REASON_INVALID = "invalid"
        const val REASON_INIT_FAILED = "init_failed"
        const val REASON_ALREADY_SHOWING = "already_showing"
        const val REASON_NO_CONNECTION = "no_connection"
        const val REASON_VIDEO_PLAYER = "player"
        const val REASON_NOT_READY = "not_ready"
    }
}