package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.*
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers

internal class GetCommonWebViewBridgeUseCase(
    private val dispatcher: CoroutineDispatcher = Dispatchers.Default,
) : GetWebViewBridgeUseCase {
    override fun invoke(webViewContainer: AndroidWebViewContainer): WebViewBridge {
        return CommonWebViewBridge(
            webViewContainer = webViewContainer,
            dispatcher = dispatcher,
        )
    }
}