/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.properties;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Base64;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.core.cache.CacheDirectory;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicReference;

public class SdkProperties {
    private static String _configUrl = null;
    private static CacheDirectory _cacheDirectory = null;
    private static final String CACHE_DIR_NAME = "UnityAdsCache";
    private static final String LOCAL_CACHE_FILE_PREFIX = "UnityAdsCache-";
    private static final String LOCAL_STORAGE_FILE_PREFIX = "UnityAdsStorage-";
    private static final String CHINA_ISO_ALPHA_2_CODE = "CN";
    private static final String CHINA_ISO_ALPHA_3_CODE = "CHN";
    private static final String DEFAULT_CONFIG_VERSION = "configv2";
    private static final String CHINA_CONFIG_HOSTNAME = "dW5pdHlhZHMudW5pdHljaGluYS5jbg==";
    private static final String DEFAULT_CONFIG_HOSTNAME = "unityads.unity3d.com";
    private static final String CONFIG_VERSION_METADATA_KEY = "com.unity3d.ads.configversion";
    private static long _initializationTime = 0L;
    private static long _initializationTimeEpochMs = 0L;
    private static Configuration _latestConfiguration;
    private static final LinkedHashSet<IUnityAdsInitializationListener> _initializationListeners;
    private static boolean _initialized;
    private static boolean _reinitialized;
    private static boolean _testMode;
    private static boolean _debugMode;
    private static final AtomicReference<InitializationState> _currentInitializationState;

    public static void notifyInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
        SdkProperties.setInitializeState(InitializationState.INITIALIZED_FAILED);
        for (IUnityAdsInitializationListener initializationListener : SdkProperties.getInitializationListeners()) {
            Utilities.wrapCustomerListener(() -> initializationListener.onInitializationFailed(error, message));
        }
        SdkProperties.resetInitializationListeners();
    }

    public static void notifyInitializationComplete() {
        SdkProperties.setInitializeState(InitializationState.INITIALIZED_SUCCESSFULLY);
        for (IUnityAdsInitializationListener initializationListener : SdkProperties.getInitializationListeners()) {
            Utilities.wrapCustomerListener(initializationListener::onInitializationComplete);
        }
        SdkProperties.resetInitializationListeners();
    }

    public static void setInitializeState(InitializationState initializeState) {
        _currentInitializationState.set(initializeState);
    }

    public static InitializationState getCurrentInitializationState() {
        return _currentInitializationState.get();
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    public static void setInitialized(boolean initialized) {
        _initialized = initialized;
    }

    public static boolean isTestMode() {
        return _testMode;
    }

    public static void setTestMode(boolean testMode) {
        _testMode = testMode;
    }

    public static int getVersionCode() {
        return 4900;
    }

    public static String getVersionName() {
        return "4.9.0";
    }

    public static String getCacheDirectoryName() {
        return CACHE_DIR_NAME;
    }

    public static String getCacheFilePrefix() {
        return LOCAL_CACHE_FILE_PREFIX;
    }

    public static String getLocalStorageFilePrefix() {
        return LOCAL_STORAGE_FILE_PREFIX;
    }

    public static void setConfigUrl(String url) throws URISyntaxException, MalformedURLException {
        if (url == null) {
            throw new MalformedURLException();
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            throw new MalformedURLException();
        }
        URL u = new URL(url);
        u.toURI();
        _configUrl = url;
    }

    public static String getConfigUrl() {
        if (_configUrl == null) {
            _configUrl = SdkProperties.getDefaultConfigUrl("release");
        }
        return _configUrl;
    }

    public static String getDefaultConfigUrl(String flavor) {
        boolean isChinaLocale = SdkProperties.isChinaLocale(Device.getNetworkCountryISO());
        String hostName = isChinaLocale ? new String(Base64.decode((String)CHINA_CONFIG_HOSTNAME, (int)0)) : DEFAULT_CONFIG_HOSTNAME;
        return "https://" + SdkProperties.getConfigVersion(ClientProperties.getApplicationContext()) + '.' + hostName + "/webview/" + SdkProperties.getWebViewBranch() + "/" + flavor + "/config.json";
    }

    public static String getConfigVersion(Context context) {
        String configVersion = DEFAULT_CONFIG_VERSION;
        try {
            if (context != null) {
                ApplicationInfo app = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                Bundle bundle = app.metaData;
                if (bundle != null) {
                    configVersion = bundle.getString(CONFIG_VERSION_METADATA_KEY, DEFAULT_CONFIG_VERSION);
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            DeviceLog.warning("Failed to retrieve application info for current package");
        }
        return configVersion;
    }

    private static String getWebViewBranch() {
        return SdkProperties.getVersionName();
    }

    public static String getLocalWebViewFile() {
        if (SdkProperties.getCacheDirectory() == null) {
            return "";
        }
        return SdkProperties.getCacheDirectory().getAbsolutePath() + "/UnityAdsWebApp.html";
    }

    public static String getLocalConfigurationFilepath() {
        if (SdkProperties.getCacheDirectory() == null) {
            return "";
        }
        return SdkProperties.getCacheDirectory().getAbsolutePath() + "/UnityAdsWebViewConfiguration.json";
    }

    public static void setLatestConfiguration(Configuration configuration) {
        _latestConfiguration = configuration;
    }

    public static Configuration getLatestConfiguration() {
        return _latestConfiguration;
    }

    public static File getCacheDirectory() {
        return SdkProperties.getCacheDirectory(ClientProperties.getApplicationContext());
    }

    public static File getCacheDirectory(Context context) {
        if (_cacheDirectory == null) {
            SdkProperties.setCacheDirectory(new CacheDirectory(CACHE_DIR_NAME));
        }
        return _cacheDirectory.getCacheDirectory(context);
    }

    public static void setCacheDirectory(CacheDirectory cacheDirectory) {
        _cacheDirectory = cacheDirectory;
    }

    public static CacheDirectory getCacheDirectoryObject() {
        return _cacheDirectory;
    }

    public static void setInitializationTime(long milliseconds) {
        _initializationTime = milliseconds;
    }

    public static long getInitializationTime() {
        return _initializationTime;
    }

    public static void setInitializationTimeSinceEpoch(long initializationTimeEpochMs) {
        _initializationTimeEpochMs = initializationTimeEpochMs;
    }

    public static long getInitializationTimeEpoch() {
        return _initializationTimeEpochMs;
    }

    public static void setReinitialized(boolean status) {
        _reinitialized = status;
    }

    public static boolean isReinitialized() {
        return _reinitialized;
    }

    public static void setDebugMode(boolean debugMode) {
        _debugMode = debugMode;
        if (debugMode) {
            DeviceLog.setLogLevel(8);
        } else {
            DeviceLog.setLogLevel(4);
        }
    }

    public static boolean getDebugMode() {
        return _debugMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitializationListener(IUnityAdsInitializationListener listener2) {
        if (listener2 == null) {
            return;
        }
        LinkedHashSet<IUnityAdsInitializationListener> linkedHashSet = _initializationListeners;
        synchronized (linkedHashSet) {
            _initializationListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUnityAdsInitializationListener[] getInitializationListeners() {
        LinkedHashSet<IUnityAdsInitializationListener> linkedHashSet = _initializationListeners;
        synchronized (linkedHashSet) {
            IUnityAdsInitializationListener[] listeners = new IUnityAdsInitializationListener[_initializationListeners.size()];
            _initializationListeners.toArray(listeners);
            return listeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInitializationListeners() {
        LinkedHashSet<IUnityAdsInitializationListener> linkedHashSet = _initializationListeners;
        synchronized (linkedHashSet) {
            _initializationListeners.clear();
        }
    }

    public static boolean isChinaLocale(String networkISOCode) {
        return networkISOCode.equalsIgnoreCase(CHINA_ISO_ALPHA_2_CODE) || networkISOCode.equalsIgnoreCase(CHINA_ISO_ALPHA_3_CODE);
    }

    static {
        _initializationListeners = new LinkedHashSet();
        _initialized = false;
        _reinitialized = false;
        _testMode = false;
        _debugMode = false;
        _currentInitializationState = new AtomicReference<InitializationState>(InitializationState.NOT_INITIALIZED);
    }

    public static enum InitializationState {
        NOT_INITIALIZED,
        INITIALIZING,
        INITIALIZED_SUCCESSFULLY,
        INITIALIZED_FAILED;

    }
}

