/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads;

import android.app.Activity;
import android.content.Context;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsLoadListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.ads.UnityAdsLoadOptions;
import com.unity3d.ads.UnityAdsShowOptions;
import com.unity3d.services.UnityServices;
import com.unity3d.services.ads.IUnityAds;
import com.unity3d.services.ads.gmascar.managers.BiddingBaseManager;
import com.unity3d.services.ads.gmascar.managers.BiddingManagerFactory;
import com.unity3d.services.ads.operation.load.LoadModule;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.ads.operation.show.ShowModule;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.ads.token.AsyncTokenStorage;
import com.unity3d.services.ads.token.TokenStorage;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.WebViewBridgeInvoker;

public final class UnityAdsImplementation
implements IUnityAds {
    private static Configuration configuration = null;
    private static WebViewBridgeInvoker webViewBridgeInvoker = new WebViewBridgeInvoker();
    private static IUnityAds instance;
    private final TokenStorage tokenStorage = (TokenStorage)Utilities.getService(TokenStorage.class);
    private final AsyncTokenStorage asyncTokenStorage = (AsyncTokenStorage)Utilities.getService(AsyncTokenStorage.class);
    private final SDKMetricsSender sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);

    public static IUnityAds getInstance() {
        if (instance == null) {
            instance = new UnityAdsImplementation();
        }
        return instance;
    }

    @Override
    public void initialize(Context context, String gameId, boolean testMode, IUnityAdsInitializationListener initializationListener) {
        DeviceLog.entered();
        UnityServices.initialize(context, gameId, testMode, initializationListener);
    }

    @Override
    public boolean isInitialized() {
        return UnityServices.isInitialized();
    }

    @Override
    public boolean isSupported() {
        return UnityServices.isSupported();
    }

    @Override
    public String getVersion() {
        return UnityServices.getVersion();
    }

    public void show(Activity activity, String placementId) {
        this.show(activity, placementId, new UnityAdsShowOptions(), null);
    }

    public void show(Activity activity, String placementId, IUnityAdsShowListener showListener) {
        this.show(activity, placementId, new UnityAdsShowOptions(), showListener);
    }

    @Override
    public void show(Activity activity, String placementId, UnityAdsShowOptions showOptions, IUnityAdsShowListener showListener) {
        if (!this.isSupported()) {
            String showErrorMessage = "Unity Ads is not supported for this device";
            this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
            return;
        }
        if (!this.isInitialized()) {
            String showErrorMessage = "Unity Ads is not initialized";
            this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.NOT_INITIALIZED, showErrorMessage);
            return;
        }
        if (activity == null) {
            String showErrorMessage = "Activity must not be null";
            this.handleShowError(showListener, placementId, UnityAds.UnityAdsShowError.INVALID_ARGUMENT, showErrorMessage);
            return;
        }
        Configuration config2 = configuration == null ? new Configuration() : configuration;
        ClientProperties.setActivity(activity);
        ShowModule.getInstance().executeAdOperation(WebViewApp.getCurrentApp(), new ShowOperationState(placementId, showListener, activity, showOptions, config2));
    }

    private void handleShowError(IUnityAdsShowListener showListener, String placementId, UnityAds.UnityAdsShowError error, String message) {
        this.sdkMetricsSender.sendMetricWithInitState(AdOperationMetric.newAdShowFailure(error, (Long)0L));
        if (showListener == null) {
            return;
        }
        showListener.onUnityAdsShowFailure(placementId, error, message);
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        UnityServices.setDebugMode(debugMode);
    }

    @Override
    public boolean getDebugMode() {
        return UnityServices.getDebugMode();
    }

    @Override
    public void load(String placementId, UnityAdsLoadOptions loadOptions, IUnityAdsLoadListener listener2) {
        Configuration config2 = configuration == null ? new Configuration() : configuration;
        LoadModule.getInstance().executeAdOperation(webViewBridgeInvoker, new LoadOperationState(placementId, listener2, loadOptions, config2));
    }

    @Override
    public String getToken() {
        String token = this.tokenStorage.getToken();
        if (token == null || token.isEmpty()) {
            return null;
        }
        Configuration config2 = configuration == null ? new ConfigurationReader().getCurrentConfiguration() : configuration;
        BiddingBaseManager manager = BiddingManagerFactory.getInstance().createManager(null, config2.getExperiments());
        manager.start();
        return manager.getFormattedToken(token);
    }

    @Override
    public void getToken(IUnityAdsTokenListener listener2) {
        if (listener2 == null) {
            DeviceLog.info("Please provide non-null listener to UnityAds.GetToken method");
            return;
        }
        if (ClientProperties.getApplicationContext() == null) {
            Utilities.wrapCustomerListener(() -> listener2.onUnityAdsTokenReady(null));
            return;
        }
        Configuration config2 = configuration == null ? new ConfigurationReader().getCurrentConfiguration() : configuration;
        BiddingBaseManager manager = BiddingManagerFactory.getInstance().createManager(null, config2.getExperiments());
        manager.start();
        this.asyncTokenStorage.getToken(manager);
    }

    public static void setConfiguration(Configuration configuration) {
        UnityAdsImplementation.configuration = configuration;
    }
}

