/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services;

import com.unity3d.services.core.domain.ISDKDispatchers;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unity3d/services/SDKErrorHandler;", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "sdkMetricsSender", "Lcom/unity3d/services/core/request/metrics/SDKMetricsSender;", "(Lcom/unity3d/services/core/domain/ISDKDispatchers;Lcom/unity3d/services/core/request/metrics/SDKMetricsSender;)V", "key", "Lkotlinx/coroutines/CoroutineExceptionHandler$Key;", "getKey", "()Lkotlinx/coroutines/CoroutineExceptionHandler$Key;", "handleException", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "sendMetric", "metric", "Lcom/unity3d/services/core/request/metrics/Metric;", "unity-ads_release"})
public final class SDKErrorHandler
implements CoroutineExceptionHandler {
    @NotNull
    private final ISDKDispatchers dispatchers;
    @NotNull
    private final SDKMetricsSender sdkMetricsSender;
    @NotNull
    private final CoroutineExceptionHandler.Key key;

    public SDKErrorHandler(@NotNull ISDKDispatchers dispatchers, @NotNull SDKMetricsSender sdkMetricsSender) {
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        Intrinsics.checkNotNullParameter((Object)sdkMetricsSender, (String)"sdkMetricsSender");
        this.dispatchers = dispatchers;
        this.sdkMetricsSender = sdkMetricsSender;
        this.key = CoroutineExceptionHandler.Key;
    }

    @NotNull
    public CoroutineExceptionHandler.Key getKey() {
        return this.key;
    }

    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        StackTraceElement stackTraceElement = exception.getStackTrace()[0];
        String string = stackTraceElement != null ? stackTraceElement.getFileName() : null;
        if (string == null) {
            string = "unknown";
        }
        String className = string;
        StackTraceElement stackTraceElement2 = exception.getStackTrace()[0];
        int line = stackTraceElement2 != null ? stackTraceElement2.getLineNumber() : 0;
        Throwable throwable = exception;
        String name = throwable instanceof NullPointerException ? "native_exception_npe" : (throwable instanceof OutOfMemoryError ? "native_exception_oom" : (throwable instanceof IllegalStateException ? "native_exception_ise" : (throwable instanceof SecurityException ? "native_exception_se" : (throwable instanceof RuntimeException ? "native_exception_re" : "native_exception"))));
        this.sendMetric(new Metric(name, className + '_' + line, null, 4, null));
    }

    private final void sendMetric(Metric metric) {
        this.sdkMetricsSender.sendMetric(metric);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        return (R)CoroutineExceptionHandler.DefaultImpls.fold((CoroutineExceptionHandler)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        return (E)CoroutineExceptionHandler.DefaultImpls.get((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        return CoroutineExceptionHandler.DefaultImpls.minusKey((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        return CoroutineExceptionHandler.DefaultImpls.plus((CoroutineExceptionHandler)this, (CoroutineContext)context);
    }
}

