/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar.managers;

import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.services.ads.gmascar.GMA;
import com.unity3d.services.ads.gmascar.listeners.IBiddingSignalsListener;
import com.unity3d.services.ads.gmascar.managers.IBiddingManager;
import com.unity3d.services.ads.gmascar.models.BiddingSignals;
import com.unity3d.services.ads.gmascar.utils.ScarRequestHandler;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.request.metrics.ScarMetric;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class BiddingBaseManager
implements IBiddingManager {
    protected final AtomicBoolean isUploadPermitted = new AtomicBoolean(false);
    private final String tokenIdentifier;
    private final IUnityAdsTokenListener unityAdsTokenListener;
    private final ScarRequestHandler _scarRequestHandler;
    private final boolean _isAsyncTokenCall;
    private final AtomicReference<BiddingSignals> signals = new AtomicReference();

    public BiddingBaseManager(IUnityAdsTokenListener unityAdsTokenListener) {
        this(unityAdsTokenListener, new ScarRequestHandler());
    }

    public BiddingBaseManager(IUnityAdsTokenListener unityAdsTokenListener, ScarRequestHandler requestSender) {
        this.tokenIdentifier = UUID.randomUUID().toString();
        this.unityAdsTokenListener = unityAdsTokenListener;
        this._isAsyncTokenCall = unityAdsTokenListener != null;
        this._scarRequestHandler = requestSender;
    }

    public abstract void start();

    public abstract void onUnityTokenSuccessfullyFetched();

    @Override
    public String getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @Override
    public String getFormattedToken(String unityToken) {
        if (unityToken == null || unityToken.isEmpty()) {
            return null;
        }
        String tokenIdentifier = this.getTokenIdentifier();
        if (tokenIdentifier == null || tokenIdentifier != null && tokenIdentifier.isEmpty()) {
            return unityToken;
        }
        return String.format("%s:%s", tokenIdentifier, unityToken);
    }

    @Override
    public final void onUnityAdsTokenReady(String token) {
        if (this.unityAdsTokenListener != null) {
            Utilities.wrapCustomerListener(() -> this.unityAdsTokenListener.onUnityAdsTokenReady(token));
        }
        if (token != null && !token.isEmpty()) {
            this.onUnityTokenSuccessfullyFetched();
        }
    }

    public void permitUpload() {
        this.isUploadPermitted.set(true);
    }

    public void permitSignalsUpload() {
        this.isUploadPermitted.set(true);
        this.attemptUpload();
    }

    public void fetchSignals() {
        this.getMetricSender().sendMetric(ScarMetric.hbSignalsFetchStart(this._isAsyncTokenCall));
        new Thread(new Runnable(){

            @Override
            public void run() {
                GMA.getInstance().getSCARBiddingSignals(new IBiddingSignalsListener(){

                    @Override
                    public void onSignalsReady(BiddingSignals signals) {
                        BiddingBaseManager.this.onSignalsReady(signals);
                        BiddingBaseManager.this.sendFetchResult("");
                    }

                    @Override
                    public void onSignalsFailure(String msg) {
                        BiddingBaseManager.this.sendFetchResult(msg);
                    }
                });
            }
        }).start();
    }

    public void sendFetchResult(String errorMsg) {
        if (errorMsg != "") {
            this.getMetricSender().sendMetric(ScarMetric.hbSignalsFetchFailure(this._isAsyncTokenCall, errorMsg));
        } else {
            this.getMetricSender().sendMetric(ScarMetric.hbSignalsFetchSuccess(this._isAsyncTokenCall));
        }
    }

    public void onSignalsReady(BiddingSignals signals) {
        this.signals.set(signals);
        this.attemptUpload();
    }

    private synchronized void attemptUpload() {
        if (this.signals.get() != null && this.isUploadPermitted.compareAndSet(true, false)) {
            this.uploadSignals();
        }
    }

    public void uploadSignals() {
        this.getMetricSender().sendMetric(ScarMetric.hbSignalsUploadStart(this._isAsyncTokenCall));
        final BiddingSignals signals = this.signals.get();
        if (signals == null || signals.isEmpty()) {
            this.getMetricSender().sendMetric(ScarMetric.hbSignalsUploadFailure(this._isAsyncTokenCall, "null or empty signals"));
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    BiddingBaseManager.this._scarRequestHandler.makeUploadRequest(BiddingBaseManager.this.tokenIdentifier, signals, new ConfigurationReader().getCurrentConfiguration().getScarBiddingUrl());
                    BiddingBaseManager.this.getMetricSender().sendMetric(ScarMetric.hbSignalsUploadSuccess(BiddingBaseManager.this._isAsyncTokenCall));
                }
                catch (Exception e) {
                    BiddingBaseManager.this.getMetricSender().sendMetric(ScarMetric.hbSignalsUploadFailure(BiddingBaseManager.this._isAsyncTokenCall, e.getLocalizedMessage()));
                }
            }
        }).start();
    }

    public SDKMetricsSender getMetricSender() {
        return (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
    }
}

