/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview;

import android.os.Build;
import android.os.ConditionVariable;
import android.os.Looper;
import android.view.View;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebViewClient;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.configuration.ErrorState;
import com.unity3d.services.core.configuration.InitializeThread;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import com.unity3d.services.core.webview.WebView;
import com.unity3d.services.core.webview.WebViewUrlBuilder;
import com.unity3d.services.core.webview.WebViewWithCache;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.Invocation;
import com.unity3d.services.core.webview.bridge.NativeCallback;
import com.unity3d.services.core.webview.bridge.WebViewBridge;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;

public class WebViewApp
implements IWebViewBridgeInvoker {
    private static WebViewApp _currentApp;
    private static ConditionVariable _conditionVariable;
    private static final int INVOKE_JS_CHARS_LENGTH = 22;
    private boolean _webAppLoaded = false;
    private WebView _webView;
    private Configuration _configuration;
    private final HashMap<String, NativeCallback> _nativeCallbacks = new HashMap();
    private static final AtomicReference<Boolean> _initialized;
    private static final AtomicReference<String> _webAppFailureMessage;
    private static final AtomicReference<Integer> _webAppFailureCode;

    public WebViewApp(Configuration configuration, boolean useWebViewWithCache, boolean shouldNotRequireGesturePlayback) {
        this.setConfiguration(configuration);
        WebViewBridge.setClassTable(this.getConfiguration().getWebAppApiClassList());
        this._webView = useWebViewWithCache ? new WebViewWithCache(ClientProperties.getApplicationContext(), shouldNotRequireGesturePlayback) : new WebView(ClientProperties.getApplicationContext(), shouldNotRequireGesturePlayback);
        this._webView.setWebViewClient(new WebAppClient());
    }

    public WebViewApp() {
    }

    public void setWebAppLoaded(boolean loaded) {
        this._webAppLoaded = loaded;
    }

    public boolean isWebAppLoaded() {
        return this._webAppLoaded;
    }

    public void setWebAppFailureMessage(String message) {
        _webAppFailureMessage.set(message);
    }

    public void setWebAppFailureCode(int code) {
        _webAppFailureCode.set(code);
    }

    public String getWebAppFailureMessage() {
        return _webAppFailureMessage.get();
    }

    public int getWebAppFailureCode() {
        return _webAppFailureCode.get();
    }

    public void setWebAppInitialized(boolean initialized) {
        _initialized.set(initialized);
        _conditionVariable.open();
    }

    public void resetWebViewAppInitialization() {
        this._webAppLoaded = false;
        _webAppFailureCode.set(-1);
        _webAppFailureMessage.set("");
        _initialized.set(false);
    }

    public boolean isWebAppInitialized() {
        return _initialized.get();
    }

    public WebView getWebView() {
        return this._webView;
    }

    public void setWebView(WebView webView) {
        this._webView = webView;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this._configuration = configuration;
    }

    private void invokeJavascriptMethod(String className, String methodName, JSONArray params) {
        String javaScript = this.buildInvokeJavascript(className, methodName, params);
        DeviceLog.debug("Invoking javascript: %s", javaScript);
        this.getWebView().invokeJavascript(javaScript);
    }

    private String buildInvokeJavascript(String className, String methodName, JSONArray params) {
        String paramsString = params.toString();
        int stringLength = 22 + className.length() + methodName.length() + paramsString.length();
        StringBuilder sb = new StringBuilder(stringLength);
        sb.append("javascript:window.");
        sb.append(className);
        sb.append(".");
        sb.append(methodName);
        sb.append("(");
        sb.append(paramsString);
        sb.append(");");
        return sb.toString();
    }

    public boolean sendEvent(Enum eventCategory, Enum eventId, Object ... params) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("sendEvent ignored because web app is not loaded");
            return false;
        }
        JSONArray paramList = new JSONArray();
        paramList.put((Object)eventCategory.name());
        paramList.put((Object)eventId.name());
        for (Object o : params) {
            paramList.put(o);
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleEvent", paramList);
        }
        catch (Exception e) {
            DeviceLog.exception("Error while sending event to WebView", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean invokeMethod(String className, String methodName, Method callback, Object ... params) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("invokeMethod ignored because web app is not loaded");
            return false;
        }
        JSONArray paramList = new JSONArray();
        paramList.put((Object)className);
        paramList.put((Object)methodName);
        if (callback != null) {
            Object[] nativeCallback = new NativeCallback(callback);
            this.addCallback((NativeCallback)nativeCallback);
            paramList.put((Object)nativeCallback.getId());
        } else {
            paramList.put(null);
        }
        if (params != null) {
            for (Object o : params) {
                paramList.put(o);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleInvocation", paramList);
        }
        catch (Exception e) {
            DeviceLog.exception("Error invoking javascript method", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean invokeCallback(Invocation invocation) {
        if (!this.isWebAppLoaded()) {
            DeviceLog.debug("invokeBatchCallback ignored because web app is not loaded");
            return false;
        }
        JSONArray responseList = new JSONArray();
        ArrayList<ArrayList<Object>> responses = invocation.getResponses();
        if (responses != null && !responses.isEmpty()) {
            for (ArrayList<Object> response : responses) {
                void var14_17;
                CallbackStatus status = (CallbackStatus)((Object)response.get(0));
                Enum error = (Enum)response.get(1);
                Object[] params = (Object[])response.get(2);
                String callbackId = (String)params[0];
                params = Arrays.copyOfRange(params, 1, params.length);
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(callbackId);
                tmp.add(status.toString());
                JSONArray paramArray = new JSONArray();
                if (error != null) {
                    paramArray.put((Object)error.name());
                }
                Object[] objectArray = params;
                int n = objectArray.length;
                boolean bl = false;
                while (var14_17 < n) {
                    Object o = objectArray[var14_17];
                    paramArray.put(o);
                    ++var14_17;
                }
                tmp.add((String)paramArray);
                JSONArray paramList = new JSONArray();
                for (Object e : tmp) {
                    paramList.put(e);
                }
                responseList.put((Object)paramList);
            }
        }
        try {
            this.invokeJavascriptMethod("nativebridge", "handleCallback", responseList);
        }
        catch (Exception e) {
            DeviceLog.exception("Error while invoking batch response for WebView", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCallback(NativeCallback callback) {
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.put(callback.getId(), callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(NativeCallback callback) {
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            this._nativeCallbacks.remove(callback.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeCallback getCallback(String callbackId) {
        HashMap<String, NativeCallback> hashMap = this._nativeCallbacks;
        synchronized (hashMap) {
            return this._nativeCallbacks.get(callbackId);
        }
    }

    public static WebViewApp getCurrentApp() {
        return _currentApp;
    }

    public static void setCurrentApp(WebViewApp app) {
        _currentApp = app;
    }

    public static ErrorState create(Configuration configuration) throws IllegalThreadStateException {
        return WebViewApp.create(configuration, false);
    }

    public static ErrorState create(final Configuration configuration, boolean useRemoteUrl) throws IllegalThreadStateException {
        boolean createdSuccessfully;
        DeviceLog.entered();
        if (useRemoteUrl) {
            return WebViewApp.createWithRemoteUrl(configuration);
        }
        if (Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            throw new IllegalThreadStateException("Cannot call create() from main thread!");
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebViewApp webViewApp;
                try {
                    webViewApp = new WebViewApp(configuration, configuration.getExperiments().isWebAssetAdCaching(), configuration.getExperiments().isWebGestureNotRequired());
                }
                catch (Exception e) {
                    DeviceLog.error("Unity Ads SDK unable to create WebViewApp");
                    _conditionVariable.open();
                    return;
                }
                WebViewUrlBuilder webViewUrlBuilder = new WebViewUrlBuilder("file://" + SdkProperties.getLocalWebViewFile(), configuration);
                String baseUrl = webViewUrlBuilder.getUrlWithQueryString();
                webViewApp.getWebView().loadDataWithBaseURL(baseUrl, configuration.getWebViewData(), "text/html", "UTF-8", null);
                WebViewApp.setCurrentApp(webViewApp);
            }
        });
        _conditionVariable = new ConditionVariable();
        boolean webViewCreateDidNotTimeout = _conditionVariable.block(configuration.getWebViewAppCreateTimeout());
        boolean webAppDefined = WebViewApp.getCurrentApp() != null;
        boolean webAppInitialized = webAppDefined && WebViewApp.getCurrentApp().isWebAppInitialized();
        boolean bl = createdSuccessfully = webViewCreateDidNotTimeout && webAppDefined && webAppInitialized;
        if (!createdSuccessfully) {
            if (!webViewCreateDidNotTimeout) {
                return ErrorState.CreateWebviewTimeout;
            }
            if (WebViewApp.getCurrentApp() == null) {
                return ErrorState.CreateWebview;
            }
            return WebViewApp.getCurrentApp().getErrorStateFromWebAppCode();
        }
        return null;
    }

    private static ErrorState createWithRemoteUrl(final Configuration configuration) {
        boolean createdSuccessfully;
        if (Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            throw new IllegalThreadStateException("Cannot call create() from main thread!");
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebViewApp webViewApp;
                try {
                    webViewApp = new WebViewApp(configuration, true, configuration.getExperiments().isWebGestureNotRequired());
                }
                catch (Exception e) {
                    DeviceLog.error("Unity Ads SDK unable to create WebViewApp");
                    _conditionVariable.open();
                    return;
                }
                WebViewUrlBuilder webViewUrlBuilder = new WebViewUrlBuilder(configuration.getWebViewUrl(), configuration);
                String baseUrl = webViewUrlBuilder.getUrlWithQueryString();
                webViewApp.getWebView().loadUrl(baseUrl);
                WebViewApp.setCurrentApp(webViewApp);
            }
        });
        _conditionVariable = new ConditionVariable();
        boolean webViewCreateDidNotTimeout = _conditionVariable.block(configuration.getWebViewAppCreateTimeout());
        boolean webAppDefined = WebViewApp.getCurrentApp() != null;
        boolean webAppInitialized = webAppDefined && WebViewApp.getCurrentApp().isWebAppInitialized();
        boolean bl = createdSuccessfully = webViewCreateDidNotTimeout && webAppDefined && webAppInitialized;
        if (!createdSuccessfully) {
            if (!webViewCreateDidNotTimeout) {
                return ErrorState.CreateWebviewTimeout;
            }
            if (WebViewApp.getCurrentApp() == null) {
                return ErrorState.CreateWebview;
            }
            return WebViewApp.getCurrentApp().getErrorStateFromWebAppCode();
        }
        return null;
    }

    public ErrorState getErrorStateFromWebAppCode() {
        int failureCode = this.getWebAppFailureCode();
        if (failureCode == 1) {
            return ErrorState.CreateWebviewGameIdDisabled;
        }
        if (failureCode == 2) {
            return ErrorState.CreateWebviewConfigError;
        }
        if (failureCode == 3) {
            return ErrorState.CreateWebviewInvalidArgument;
        }
        return ErrorState.CreateWebview;
    }

    static {
        _initialized = new AtomicReference<Boolean>(false);
        _webAppFailureMessage = new AtomicReference();
        _webAppFailureCode = new AtomicReference();
    }

    private static class WebAppClient
    extends WebViewClient {
        private WebAppClient() {
        }

        public boolean onRenderProcessGone(android.webkit.WebView view, final RenderProcessGoneDetail detail) {
            Utilities.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (AdUnit.getAdUnitActivity() != null) {
                        AdUnit.getAdUnitActivity().finish();
                    }
                    if (WebViewApp.getCurrentApp() != null && WebViewApp.getCurrentApp().getWebView() != null) {
                        ViewUtilities.removeViewFromParent((View)WebViewApp.getCurrentApp().getWebView());
                    }
                    InitializeThread.reset();
                }
            });
            DeviceLog.error("UnityAds SDK WebView render process gone with following reason : " + detail.toString());
            SDKMetrics.getInstance().sendEvent("native_webview_render_process_gone", (Map<String, String>)new HashMap<String, String>(){
                {
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.put("dc", "" + detail.didCrash());
                        this.put("pae", "" + detail.rendererPriorityAtExit());
                    }
                }
            });
            return true;
        }

        public void onPageFinished(android.webkit.WebView webview, String url) {
            super.onPageFinished(webview, url);
            DeviceLog.debug("Unity Ads SDK finished loading URL inside WebView: " + url);
        }

        public boolean shouldOverrideUrlLoading(android.webkit.WebView view, String url) {
            DeviceLog.debug("Unity Ads SDK attempts to load URL inside WebView: " + url);
            return false;
        }

        public void onReceivedError(android.webkit.WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            if (Build.VERSION.SDK_INT >= 23 && request != null && error != null) {
                DeviceLog.error("Unity Ads SDK encountered an error (code: " + error.getErrorCode() + ")  in WebView while loading a resource " + request.getUrl());
            } else if (Build.VERSION.SDK_INT >= 21 && request != null) {
                DeviceLog.error("Unity Ads SDK encountered an error in WebView while loading a resource " + request.getUrl());
            } else {
                DeviceLog.error("Unity Ads SDK encountered an error in WebView while loading a resource");
            }
        }
    }
}

