/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.lifecycle;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import com.unity3d.scar.adapter.common.Utils;
import com.unity3d.services.core.configuration.ConfigurationReader;
import com.unity3d.services.core.lifecycle.IAppActiveListener;
import com.unity3d.services.core.lifecycle.IAppEventListener;
import com.unity3d.services.core.lifecycle.LifecycleEvent;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=14)
public class LifecycleCache
implements Application.ActivityLifecycleCallbacks,
LifecycleEventObserver {
    private LifecycleEvent _currentState = LifecycleEvent.RESUMED;
    private boolean _appActive = true;
    private boolean _lifecycleAppActive = true;
    private int _numStarted = 0;
    private boolean _newLifecycle = false;
    private final Set<IAppActiveListener> _appActiveListeners = new HashSet<IAppActiveListener>();
    private final Set<IAppEventListener> _appStateListeners = new HashSet<IAppEventListener>();

    LifecycleCache(ConfigurationReader configurationReader) {
        this._newLifecycle = configurationReader.getCurrentConfiguration().getExperiments().isJetpackLifecycle();
        this.startProcessLifecycleObserving();
    }

    private void startProcessLifecycleObserving() {
        Utils.runOnUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LifecycleCache.this.registerLifecycleObserver();
            }
        });
    }

    private void registerLifecycleObserver() {
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.CREATED;
    }

    public void onActivityStarted(Activity activity) {
        this._currentState = LifecycleEvent.STARTED;
        if (this._numStarted == 0) {
            this._appActive = true;
            if (!this._newLifecycle) {
                this.notifyActiveListeners();
            }
        }
        ++this._numStarted;
    }

    public void onActivityResumed(Activity activity) {
        this._currentState = LifecycleEvent.RESUMED;
        this.notifyStateListeners(LifecycleEvent.RESUMED);
    }

    public void onActivityPaused(Activity activity) {
        this._currentState = LifecycleEvent.PAUSED;
        this.notifyStateListeners(LifecycleEvent.PAUSED);
    }

    public void onActivityStopped(Activity activity) {
        this._currentState = LifecycleEvent.STOPPED;
        --this._numStarted;
        if (this._numStarted <= 0) {
            this._numStarted = 0;
            this._appActive = false;
            if (!this._newLifecycle) {
                this.notifyActiveListeners();
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.SAVE_INSTANCE_STATE;
    }

    public void onActivityDestroyed(Activity activity) {
        this._currentState = LifecycleEvent.DESTROYED;
    }

    public LifecycleEvent getCurrentState() {
        return this._currentState;
    }

    public boolean isAppActive() {
        return this._newLifecycle ? this._lifecycleAppActive : this._appActive;
    }

    public synchronized void notifyStateListeners(LifecycleEvent event) {
        for (IAppEventListener listener : this._appStateListeners) {
            listener.onLifecycleEvent(event);
        }
    }

    public synchronized void notifyActiveListeners() {
        for (IAppActiveListener listener : this._appActiveListeners) {
            listener.onAppStateChanged(this._appActive);
        }
    }

    public synchronized void addActiveListener(IAppActiveListener listener) {
        this._appActiveListeners.add(listener);
    }

    public synchronized void removeActiveListener(IAppActiveListener listener) {
        this._appActiveListeners.remove(listener);
    }

    public synchronized void addStateListener(IAppEventListener listener) {
        this._appStateListeners.add(listener);
    }

    public synchronized void removeStateListener(IAppEventListener listener) {
        this._appStateListeners.remove(listener);
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        switch (event) {
            case ON_STOP: {
                this._lifecycleAppActive = false;
                if (!this._newLifecycle) break;
                this.notifyActiveListeners();
                break;
            }
            case ON_START: {
                this._lifecycleAppActive = true;
                if (!this._newLifecycle) break;
                this.notifyActiveListeners();
            }
        }
    }
}

