/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.lifecycle;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.unity3d.services.core.lifecycle.IAppActiveListener;
import com.unity3d.services.core.lifecycle.IAppEventListener;
import com.unity3d.services.core.lifecycle.LifecycleEvent;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=14)
public class LifecycleCache
implements Application.ActivityLifecycleCallbacks {
    private LifecycleEvent _currentState = LifecycleEvent.RESUMED;
    private boolean _appActive = true;
    private int _numStarted = 0;
    private final Set<IAppActiveListener> _appActiveListeners = new HashSet<IAppActiveListener>();
    private final Set<IAppEventListener> _appStateListeners = new HashSet<IAppEventListener>();

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.CREATED;
    }

    public void onActivityStarted(Activity activity) {
        this._currentState = LifecycleEvent.STARTED;
        if (this._numStarted == 0) {
            this._appActive = true;
            this.notifyActiveListeners();
        }
        ++this._numStarted;
    }

    public void onActivityResumed(Activity activity) {
        this._currentState = LifecycleEvent.RESUMED;
        this.notifyStateListeners(LifecycleEvent.RESUMED);
    }

    public void onActivityPaused(Activity activity) {
        this._currentState = LifecycleEvent.PAUSED;
        this.notifyStateListeners(LifecycleEvent.PAUSED);
    }

    public void onActivityStopped(Activity activity) {
        this._currentState = LifecycleEvent.STOPPED;
        --this._numStarted;
        if (this._numStarted <= 0) {
            this._numStarted = 0;
            this._appActive = false;
            this.notifyActiveListeners();
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this._currentState = LifecycleEvent.SAVE_INSTANCE_STATE;
    }

    public void onActivityDestroyed(Activity activity) {
        this._currentState = LifecycleEvent.DESTROYED;
    }

    public LifecycleEvent getCurrentState() {
        return this._currentState;
    }

    public boolean isAppActive() {
        return this._appActive;
    }

    public synchronized void notifyStateListeners(LifecycleEvent event) {
        for (IAppEventListener listener : this._appStateListeners) {
            listener.onLifecycleEvent(event);
        }
    }

    public synchronized void notifyActiveListeners() {
        for (IAppActiveListener listener : this._appActiveListeners) {
            listener.onAppStateChanged(this._appActive);
        }
    }

    public synchronized void addActiveListener(IAppActiveListener listener) {
        this._appActiveListeners.add(listener);
    }

    public synchronized void removeActiveListener(IAppActiveListener listener) {
        this._appActiveListeners.remove(listener);
    }

    public synchronized void addStateListener(IAppEventListener listener) {
        this._appStateListeners.add(listener);
    }

    public synchronized void removeStateListener(IAppEventListener listener) {
        this._appStateListeners.remove(listener);
    }
}

