/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.video;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Build;
import android.widget.VideoView;
import com.unity3d.services.ads.video.VideoPlayerEvent;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.Timer;
import java.util.TimerTask;

public class VideoPlayerView
extends VideoView {
    private String _videoUrl;
    private Timer _videoTimer;
    private Timer _prepareTimer;
    private int _progressEventInterval = 500;
    private MediaPlayer _mediaPlayer = null;
    private Float _volume = null;
    private boolean _infoListenerEnabled = true;
    private AudioManager _audioManager = null;

    public VideoPlayerView(Context context) {
        super(context);
    }

    private void startVideoProgressTimer() {
        this._videoTimer = new Timer();
        this._videoTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                boolean isPlaying = false;
                try {
                    isPlaying = VideoPlayerView.this.isPlaying();
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PROGRESS, VideoPlayerView.this.getCurrentPosition());
                }
                catch (IllegalStateException e) {
                    DeviceLog.exception("Exception while sending current position to webapp", e);
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.ILLEGAL_STATE, new Object[]{VideoPlayerEvent.PROGRESS, VideoPlayerView.this._videoUrl, isPlaying});
                }
            }
        }, this._progressEventInterval, (long)this._progressEventInterval);
    }

    public void stopVideoProgressTimer() {
        if (this._videoTimer != null) {
            this._videoTimer.cancel();
            this._videoTimer.purge();
            this._videoTimer = null;
        }
    }

    private void startPrepareTimer(long delay) {
        this._prepareTimer = new Timer();
        this._prepareTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean isPlaying = false;
                try {
                    isPlaying = VideoPlayerView.this.isPlaying();
                    if (!isPlaying) {
                        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PREPARE_TIMEOUT, VideoPlayerView.this._videoUrl);
                        DeviceLog.error("Video player prepare timeout: " + VideoPlayerView.this._videoUrl);
                    }
                }
                catch (IllegalStateException e) {
                    DeviceLog.exception("Exception while preparing timer", e);
                    WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.ILLEGAL_STATE, new Object[]{VideoPlayerEvent.PREPARE_TIMEOUT, VideoPlayerView.this._videoUrl, isPlaying});
                }
            }
        }, delay);
    }

    public void stopPrepareTimer() {
        if (this._prepareTimer != null) {
            this._prepareTimer.cancel();
            this._prepareTimer.purge();
            this._prepareTimer = null;
        }
    }

    public boolean prepare(String url, final float initialVolume, int timeout) {
        DeviceLog.entered();
        this._videoUrl = url;
        this.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                VideoPlayerView.this.stopPrepareTimer();
                if (mp != null) {
                    VideoPlayerView.this._mediaPlayer = mp;
                }
                VideoPlayerView.this.setVolume(Float.valueOf(initialVolume));
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PREPARED, VideoPlayerView.this._videoUrl, mp.getDuration(), mp.getVideoWidth(), mp.getVideoHeight());
            }
        });
        this.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mp, int what, int extra) {
                VideoPlayerView.this.stopPrepareTimer();
                if (mp != null) {
                    VideoPlayerView.this._mediaPlayer = mp;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.GENERIC_ERROR, VideoPlayerView.this._videoUrl, what, extra);
                VideoPlayerView.this.stopVideoProgressTimer();
                return true;
            }
        });
        this.setInfoListenerEnabled(this._infoListenerEnabled);
        if (timeout > 0) {
            this.startPrepareTimer(timeout);
        }
        try {
            if (Build.VERSION.SDK_INT < 26) {
                this._audioManager = (AudioManager)this.getContext().getSystemService("audio");
                if (this._audioManager != null) {
                    this._audioManager.requestAudioFocus(null, 3, 2);
                }
            } else {
                this.setAudioFocusRequest(2);
            }
            this.setVideoPath(this._videoUrl);
        }
        catch (Exception e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PREPARE_ERROR, this._videoUrl);
            DeviceLog.exception("Error preparing video: " + this._videoUrl, e);
            return false;
        }
        return true;
    }

    public void play() {
        DeviceLog.entered();
        this.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (mp != null) {
                    VideoPlayerView.this._mediaPlayer = mp;
                }
                WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.COMPLETED, VideoPlayerView.this._videoUrl);
                VideoPlayerView.this.stopVideoProgressTimer();
            }
        });
        try {
            this.start();
            this.stopVideoProgressTimer();
            this.startVideoProgressTimer();
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PLAY, this._videoUrl);
        }
        catch (IllegalStateException ex) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.ILLEGAL_STATE, this._videoUrl, false);
        }
    }

    public void setInfoListenerEnabled(boolean enabled) {
        this._infoListenerEnabled = enabled;
        if (Build.VERSION.SDK_INT > 16) {
            if (this._infoListenerEnabled) {
                this.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                    public boolean onInfo(MediaPlayer mp, int what, int extra) {
                        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.INFO, VideoPlayerView.this._videoUrl, what, extra);
                        return true;
                    }
                });
            } else {
                this.setOnInfoListener(null);
            }
        }
    }

    public void pause() {
        try {
            super.pause();
            if (Build.VERSION.SDK_INT < 26) {
                if (this._audioManager != null) {
                    this._audioManager.abandonAudioFocus(null);
                }
            } else {
                this.setAudioFocusRequest(0);
            }
        }
        catch (Exception e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PAUSE_ERROR, this._videoUrl);
            DeviceLog.exception("Error pausing video", e);
            return;
        }
        this.stopVideoProgressTimer();
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.PAUSE, this._videoUrl);
    }

    public void seekTo(int msec) {
        try {
            super.seekTo(msec);
        }
        catch (Exception e) {
            WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.SEEKTO_ERROR, this._videoUrl);
            DeviceLog.exception("Error seeking video", e);
            return;
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.SEEKTO, this._videoUrl);
    }

    public void stop() {
        this.stopPlayback();
        this.stopVideoProgressTimer();
        if (Build.VERSION.SDK_INT < 26) {
            if (this._audioManager != null) {
                this._audioManager.abandonAudioFocus(null);
            }
        } else {
            this.setAudioFocusRequest(0);
        }
        WebViewApp.getCurrentApp().sendEvent(WebViewEventCategory.VIDEOPLAYER, VideoPlayerEvent.STOP, this._videoUrl);
    }

    public float getVolume() {
        return this._volume.floatValue();
    }

    public void setVolume(Float volume) {
        try {
            this._mediaPlayer.setVolume(volume.floatValue(), volume.floatValue());
            this._volume = volume;
        }
        catch (Exception e) {
            DeviceLog.exception("MediaPlayer generic error", e);
            return;
        }
    }

    public void setProgressEventInterval(int ms) {
        this._progressEventInterval = ms;
        if (this._videoTimer != null) {
            this.stopVideoProgressTimer();
            this.startVideoProgressTimer();
        }
    }

    public int getProgressEventInterval() {
        return this._progressEventInterval;
    }

    public int[] getVideoViewRectangle() {
        int[] xyPoint = new int[2];
        this.getLocationInWindow(xyPoint);
        return new int[]{xyPoint[0], xyPoint[1], this.getMeasuredWidth(), this.getMeasuredHeight()};
    }
}

