/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services;

import com.unity3d.services.core.domain.ISDKDispatchers;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetrics;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/unity3d/services/SDKErrorHandler;", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "(Lcom/unity3d/services/core/domain/ISDKDispatchers;)V", "key", "Lkotlinx/coroutines/CoroutineExceptionHandler$Key;", "getKey", "()Lkotlinx/coroutines/CoroutineExceptionHandler$Key;", "handleException", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "sendMetric", "metric", "Lcom/unity3d/services/core/request/metrics/Metric;", "unity-ads_release"})
public final class SDKErrorHandler
implements CoroutineExceptionHandler {
    @NotNull
    private final CoroutineExceptionHandler.Key key;
    private final ISDKDispatchers dispatchers;

    @NotNull
    public CoroutineExceptionHandler.Key getKey() {
        return this.key;
    }

    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        StackTraceElement stackTraceElement = exception.getStackTrace()[0];
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"exception.stackTrace[0]");
        String string = stackTraceElement.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exception.stackTrace[0].fileName");
        String className = string;
        StackTraceElement stackTraceElement2 = exception.getStackTrace()[0];
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement2, (String)"exception.stackTrace[0]");
        int line = stackTraceElement2.getLineNumber();
        Throwable throwable = exception;
        String name = throwable instanceof NullPointerException ? "native_exception_npe" : (throwable instanceof OutOfMemoryError ? "native_exception_oom" : (throwable instanceof IllegalStateException ? "native_exception_ise" : (throwable instanceof RuntimeException ? "native_exception_re" : (throwable instanceof SecurityException ? "native_exception_se" : "native_exception"))));
        this.sendMetric(new Metric(name, '{' + className + "}_" + line, null));
    }

    private final void sendMetric(Metric metric) {
        SDKMetrics.getInstance().sendMetric(metric);
    }

    public SDKErrorHandler(@NotNull ISDKDispatchers dispatchers) {
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        this.dispatchers = dispatchers;
        this.key = CoroutineExceptionHandler.Key;
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        return (R)CoroutineExceptionHandler.DefaultImpls.fold((CoroutineExceptionHandler)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (E)CoroutineExceptionHandler.DefaultImpls.get((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return CoroutineExceptionHandler.DefaultImpls.minusKey((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return CoroutineExceptionHandler.DefaultImpls.plus((CoroutineExceptionHandler)this, (CoroutineContext)context);
    }
}

