/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import com.unity3d.services.core.configuration.ExperimentAppliedRule;
import com.unity3d.services.core.configuration.ExperimentObject;
import com.unity3d.services.core.configuration.ExperimentsBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class ExperimentObjects
extends ExperimentsBase {
    private final JSONObject _experimentObjetsData;
    private final Map<String, ExperimentObject> _experimentObjects = new HashMap<String, ExperimentObject>();

    public ExperimentObjects(JSONObject experimentObjects) {
        if (experimentObjects != null) {
            this._experimentObjetsData = experimentObjects;
            Iterator it = experimentObjects.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                this._experimentObjects.put(key, new ExperimentObject(experimentObjects.optJSONObject(key)));
            }
        } else {
            this._experimentObjetsData = new JSONObject();
        }
    }

    public ExperimentObject getExperimentObject(String experimentName) {
        return this._experimentObjects.get(experimentName);
    }

    @Override
    public boolean isTwoStageInitializationEnabled() {
        return this.getExperimentValue("tsi", true);
    }

    @Override
    public boolean isForwardExperimentsToWebViewEnabled() {
        return this.getExperimentValueOrDefault("fff");
    }

    @Override
    public boolean isNativeTokenEnabled() {
        return this.getExperimentValue("tsi_nt", true);
    }

    @Override
    public boolean isUpdatePiiFields() {
        return this.getExperimentValueOrDefault("tsi_upii");
    }

    @Override
    public boolean isPrivacyRequestEnabled() {
        return this.getExperimentValue("tsi_prr", true);
    }

    @Override
    public boolean shouldNativeTokenAwaitPrivacy() {
        return this.getExperimentValueOrDefault("tsi_prw");
    }

    @Override
    public boolean isNativeWebViewCacheEnabled() {
        return this.getExperimentValueOrDefault("nwc");
    }

    @Override
    public boolean isWebAssetAdCaching() {
        return this.getExperimentValueOrDefault("wac");
    }

    @Override
    public boolean isWebGestureNotRequired() {
        return this.getExperimentValueOrDefault("wgr");
    }

    @Override
    public boolean isNewLifecycleTimer() {
        return this.getExperimentValueOrDefault("nlt");
    }

    private boolean getExperimentValue(String experimentName, boolean defaultValue) {
        ExperimentObject expo = this.getExperimentObject(experimentName);
        return expo != null ? expo.getBooleanValue() : defaultValue;
    }

    private boolean getExperimentValueOrDefault(String experimentName) {
        return this.getExperimentValue(experimentName, false);
    }

    @Override
    public JSONObject getExperimentsAsJson() {
        return this._experimentObjetsData;
    }

    @Override
    public Map<String, String> getExperimentTags() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ExperimentObject> entry : this._experimentObjects.entrySet()) {
            map.put(entry.getKey(), String.valueOf(entry.getValue().getBooleanValue()));
        }
        return map;
    }

    @Override
    public JSONObject getCurrentSessionExperiments() {
        return this.getExperimentWithAppliedRule(ExperimentAppliedRule.IMMEDIATE);
    }

    @Override
    public JSONObject getNextSessionExperiments() {
        return this.getExperimentWithAppliedRule(ExperimentAppliedRule.NEXT);
    }

    private JSONObject getExperimentWithAppliedRule(ExperimentAppliedRule experimentAppliedRule) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ExperimentObject> entry : this._experimentObjects.entrySet()) {
            if (entry.getValue().getAppliedRule() != experimentAppliedRule) continue;
            map.put(entry.getKey(), String.valueOf(entry.getValue().getBooleanValue()));
        }
        return new JSONObject(map);
    }
}

