/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.gmascar;

import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.GMAEvent;
import com.unity3d.scar.adapter.common.IScarAdapter;
import com.unity3d.scar.adapter.common.IScarInterstitialAdListenerWrapper;
import com.unity3d.scar.adapter.common.IScarRewardedAdListenerWrapper;
import com.unity3d.scar.adapter.common.WebViewAdsError;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.services.ads.gmascar.adapters.ScarAdapterFactory;
import com.unity3d.services.ads.gmascar.bridges.AdapterStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializationStatusBridge;
import com.unity3d.services.ads.gmascar.bridges.InitializeListenerBridge;
import com.unity3d.services.ads.gmascar.bridges.MobileAdsBridge;
import com.unity3d.services.ads.gmascar.finder.GMAInitializer;
import com.unity3d.services.ads.gmascar.finder.PresenceDetector;
import com.unity3d.services.ads.gmascar.finder.ScarVersionFinder;
import com.unity3d.services.ads.gmascar.handlers.ScarInterstitialAdHandler;
import com.unity3d.services.ads.gmascar.handlers.ScarRewardedAdHandler;
import com.unity3d.services.ads.gmascar.handlers.SignalsHandler;
import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler;
import com.unity3d.services.ads.gmascar.utils.GMAEventSender;
import com.unity3d.services.core.misc.EventSubject;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.timer.DefaultIntervalTimerFactory;
import java.util.ArrayDeque;
import java.util.Arrays;

public class GMAScarAdapterBridge {
    private IScarAdapter _scarAdapter;
    private final MobileAdsBridge _mobileAdsBridge = new MobileAdsBridge();
    private final ScarVersionFinder _scarVersionFinder;
    private final InitializeListenerBridge _initializationListenerBridge;
    private final InitializationStatusBridge _initializationStatusBridge = new InitializationStatusBridge();
    private final AdapterStatusBridge _adapterStatusBridge;
    private final PresenceDetector _presenceDetector;
    private final GMAInitializer _gmaInitializer;
    private final WebViewErrorHandler _webViewErrorHandler;
    private final ScarAdapterFactory _scarAdapterFactory;
    private final GMAEventSender _gmaEventSender;

    public GMAScarAdapterBridge() {
        this._initializationListenerBridge = new InitializeListenerBridge();
        this._adapterStatusBridge = new AdapterStatusBridge();
        this._webViewErrorHandler = new WebViewErrorHandler();
        this._scarAdapterFactory = new ScarAdapterFactory();
        this._presenceDetector = new PresenceDetector(this._mobileAdsBridge, this._initializationListenerBridge, this._initializationStatusBridge, this._adapterStatusBridge);
        this._gmaInitializer = new GMAInitializer(this._mobileAdsBridge, this._initializationListenerBridge, this._initializationStatusBridge, this._adapterStatusBridge);
        this._scarVersionFinder = new ScarVersionFinder(this._mobileAdsBridge, this._presenceDetector, this._gmaInitializer);
        this._gmaEventSender = new GMAEventSender();
    }

    public void initializeScar() {
        if (this._presenceDetector.areGMAClassesPresent()) {
            this._gmaEventSender.send(GMAEvent.SCAR_PRESENT, new Object[0]);
            this._gmaInitializer.initializeGMA();
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)new GMAAdsError(GMAEvent.SCAR_NOT_PRESENT, new Object[0]));
        }
    }

    public boolean isInitialized() {
        return this._gmaInitializer.isInitialized();
    }

    public void getVersion() {
        this._scarVersionFinder.getVersion();
    }

    public void getSCARSignals(String[] interstitialList, String[] rewardedList) {
        this._scarAdapter = this.getScarAdapterObject();
        SignalsHandler signalListener = new SignalsHandler();
        if (this._scarAdapter != null) {
            this._scarAdapter.getSCARSignals(ClientProperties.getApplicationContext(), interstitialList, rewardedList, (ISignalCollectionListener)signalListener);
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)GMAAdsError.InternalSignalsError((String)"Could not create SCAR adapter object"));
        }
    }

    public void load(boolean canSkip, String placementId, String queryId, String adString, String adUnitId, int videoLengthMs) {
        ScarAdMetadata scarAdMetadata = new ScarAdMetadata(placementId, queryId, adUnitId, adString, Integer.valueOf(videoLengthMs));
        this._scarAdapter = this.getScarAdapterObject();
        if (this._scarAdapter != null) {
            if (canSkip) {
                this.loadInterstitialAd(scarAdMetadata);
            } else {
                this.loadRewardedAd(scarAdMetadata);
            }
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)GMAAdsError.InternalLoadError((ScarAdMetadata)scarAdMetadata, (String)"Scar Adapter object is null"));
        }
    }

    private void loadInterstitialAd(ScarAdMetadata scarAdMetadata) {
        ScarInterstitialAdHandler adListener = new ScarInterstitialAdHandler(scarAdMetadata, this.getScarEventSubject(scarAdMetadata.getVideoLengthMs()));
        this._scarAdapter.loadInterstitialAd(ClientProperties.getApplicationContext(), scarAdMetadata, (IScarInterstitialAdListenerWrapper)adListener);
    }

    private void loadRewardedAd(ScarAdMetadata scarAdMetadata) {
        ScarRewardedAdHandler adListener = new ScarRewardedAdHandler(scarAdMetadata, this.getScarEventSubject(scarAdMetadata.getVideoLengthMs()));
        this._scarAdapter.loadRewardedAd(ClientProperties.getApplicationContext(), scarAdMetadata, (IScarRewardedAdListenerWrapper)adListener);
    }

    public void show(String placementId, String queryId, boolean canSkip) {
        ScarAdMetadata scarAdMetadata = new ScarAdMetadata(placementId, queryId);
        this._scarAdapter = this.getScarAdapterObject();
        if (this._scarAdapter != null) {
            this._scarAdapter.show(ClientProperties.getActivity(), queryId, placementId);
        } else {
            this._webViewErrorHandler.handleError((WebViewAdsError)GMAAdsError.InternalShowError((ScarAdMetadata)scarAdMetadata, (String)"Scar Adapter object is null"));
        }
    }

    private EventSubject getScarEventSubject(Integer videoLengthMs) {
        return new EventSubject<GMAEvent>(new ArrayDeque<GMAEvent>(Arrays.asList(GMAEvent.FIRST_QUARTILE, GMAEvent.MIDPOINT, GMAEvent.THIRD_QUARTILE, GMAEvent.LAST_QUARTILE)), videoLengthMs, new DefaultIntervalTimerFactory());
    }

    private IScarAdapter getScarAdapterObject() {
        if (this._scarAdapter == null) {
            long minorVersion = this._scarVersionFinder.getGoogleSdkVersionCode();
            this._scarAdapter = this._scarAdapterFactory.createScarAdapter(minorVersion, this._webViewErrorHandler);
        }
        return this._scarAdapter;
    }
}

