/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.load;

import android.os.ConditionVariable;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.load.ILoadModule;
import com.unity3d.services.ads.operation.load.ILoadOperation;
import com.unity3d.services.ads.operation.load.LoadModuleDecorator;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.core.request.metrics.SDKMetricEvents;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LoadModuleDecoratorTimeout
extends LoadModuleDecorator {
    private static String errorMsgTimeoutLoading = "[UnityAds] Timeout while loading ";
    private ExecutorService _executorService = Executors.newCachedThreadPool();

    public LoadModuleDecoratorTimeout(ILoadModule loadModule) {
        super(loadModule);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, LoadOperationState state) {
        this.startLoadTimeout(state);
        super.executeAdOperation(webViewBridgeInvoker, state);
    }

    private void startLoadTimeout(final LoadOperationState loadOperationState) {
        this._executorService.submit(new Runnable(){

            @Override
            public void run() {
                if (!loadOperationState.timeoutCV.block((long)loadOperationState.configuration.getLoadTimeout())) {
                    LoadModuleDecoratorTimeout.this.onOperationTimeout(loadOperationState);
                }
            }
        });
    }

    @Override
    public void onUnityAdsAdLoaded(String operationId) {
        this.releaseOperationTimeoutLock(operationId);
        super.onUnityAdsAdLoaded(operationId);
    }

    @Override
    public void onUnityAdsFailedToLoad(String operationId, UnityAds.UnityAdsLoadError error, String message) {
        this.releaseOperationTimeoutLock(operationId);
        super.onUnityAdsFailedToLoad(operationId, error, message);
    }

    private void releaseOperationTimeoutLock(String operationId) {
        ILoadOperation loadOperation = this.get(operationId);
        if (loadOperation == null) {
            return;
        }
        LoadOperationState loadOperationState = loadOperation.getLoadOperationState();
        if (loadOperationState == null) {
            return;
        }
        ConditionVariable timeoutCV = loadOperation.getLoadOperationState().timeoutCV;
        if (timeoutCV == null) {
            return;
        }
        loadOperation.getLoadOperationState().timeoutCV.open();
    }

    private void onOperationTimeout(LoadOperationState state) {
        this.remove(state.id);
        state.listener.onUnityAdsFailedToLoad(state.placementId, UnityAds.UnityAdsLoadError.TIMEOUT, errorMsgTimeoutLoading + state.placementId);
        this.getMetricSender().sendSDKMetricEvent(SDKMetricEvents.native_load_timeout_error);
    }
}

