/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.load;

import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.load.ILoadModule;
import com.unity3d.services.ads.operation.load.LoadModuleDecorator;
import com.unity3d.services.ads.operation.load.LoadOperationState;
import com.unity3d.services.core.configuration.IInitializationListener;
import com.unity3d.services.core.configuration.IInitializationNotificationCenter;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoadModuleDecoratorInitializationBuffer
extends LoadModuleDecorator
implements IInitializationListener {
    private static String errorMsgInitializationFailed = "[UnityAds] SDK Initialization Failed";
    private static String errorMsgInitializationFailure = "[UnityAds] SDK Initialization Failure";
    private ConcurrentHashMap<LoadOperationState, IWebViewBridgeInvoker> _queuedLoadEvents;

    public LoadModuleDecoratorInitializationBuffer(ILoadModule loadModule, IInitializationNotificationCenter initializationNotificationCenter) {
        super(loadModule);
        initializationNotificationCenter.addListener(this);
        this._queuedLoadEvents = new ConcurrentHashMap();
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, LoadOperationState state) {
        if (state == null) {
            return;
        }
        switch (SdkProperties.getCurrentInitializationState()) {
            case INITIALIZED_SUCCESSFULLY: {
                super.executeAdOperation(webViewBridgeInvoker, state);
                break;
            }
            case INITIALIZED_FAILED: {
                this.sendOnUnityAdsFailedToLoad(state, UnityAds.UnityAdsLoadError.INITIALIZE_FAILED, errorMsgInitializationFailed);
                break;
            }
            default: {
                this._queuedLoadEvents.put(state, webViewBridgeInvoker);
            }
        }
    }

    @Override
    public synchronized void onSdkInitialized() {
        for (Map.Entry<LoadOperationState, IWebViewBridgeInvoker> queuedLoadEvent : this._queuedLoadEvents.entrySet()) {
            super.executeAdOperation(queuedLoadEvent.getValue(), queuedLoadEvent.getKey());
        }
        this._queuedLoadEvents.clear();
    }

    @Override
    public synchronized void onSdkInitializationFailed(String message, int code) {
        for (LoadOperationState queuedLoadOperationState : this._queuedLoadEvents.keySet()) {
            this.sendOnUnityAdsFailedToLoad(queuedLoadOperationState, UnityAds.UnityAdsLoadError.INITIALIZE_FAILED, errorMsgInitializationFailure);
        }
        this._queuedLoadEvents.clear();
    }

    private void sendOnUnityAdsFailedToLoad(final LoadOperationState state, final UnityAds.UnityAdsLoadError error, final String message) {
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                state.listener.onUnityAdsFailedToLoad(state.placementId, error, message);
            }
        });
    }
}

