/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.misc;

import com.unity3d.services.core.misc.IObserver;
import java.util.ArrayList;
import java.util.List;

public abstract class Observable<T> {
    private final List<IObserver<T>> _observers = new ArrayList<IObserver<T>>();

    public synchronized void registerObserver(IObserver<T> observer) {
        if (this._observers.contains(observer)) {
            return;
        }
        this._observers.add(observer);
    }

    public synchronized void unregisterObserver(IObserver<T> observer) {
        if (this._observers.contains(observer)) {
            this._observers.remove(observer);
        }
    }

    protected synchronized void notifyObservers(T value) {
        for (IObserver<T> observer : this._observers) {
            observer.updated(value);
        }
    }
}

