package com.unity3d.ads.core.extensions

import okio.ByteString
import java.net.URLConnection

fun String.getSHA256Hash(): String {
    val bytes = ByteString.of(*this.toByteArray())
    return bytes.sha256().hex()
}

fun String.guessMimeType(): String? = URLConnection.guessContentTypeFromName(this)