package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DeveloperConsentRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.extensions.fromMillis
import com.unity3d.services.core.properties.SdkProperties
import gatewayprotocol.v1.UniversalRequestKt.sharedData
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest.SharedData

internal class AndroidGetUniversalRequestSharedData(
    private val getSharedDataTimestamps: GetSharedDataTimestamps,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val getLimitedSessionToken: GetLimitedSessionToken,
    private val developerConsentRepository: DeveloperConsentRepository
) : GetUniversalRequestSharedData {
    override suspend fun invoke(): SharedData {
        return sharedData {
            val sToken = sessionRepository.sessionToken
            if (!sToken.isEmpty) {
                sessionToken = sToken
            } else {
                limitedSessionToken = getLimitedSessionToken()
            }
            timestamps = getSharedDataTimestamps()
            // UTC timestamp when application called initialize method in milliseconds
            sdkStartTime = fromMillis(SdkProperties.getInitializationTimeEpoch())
            // UTC timestamp when application started in milliseconds
            appStartTime = fromMillis(SdkProperties.getAppInitializationTimeSinceEpoch())
            developerConsent = developerConsentRepository.developerConsent
            pii = deviceInfoRepository.piiData
        }
    }
}
