package com.unity3d.ads.core.domain

import com.unity3d.services.UnityAdsConstants.SafeGuards
import gatewayprotocol.v1.NativeConfigurationOuterClass.RequestPolicy
import gatewayprotocol.v1.NativeConfigurationOuterClass.RequestRetryPolicy
import gatewayprotocol.v1.NativeConfigurationOuterClass.RequestTimeoutPolicy

internal class AndroidGetSafeguardedInitializationPolicy : GetSafeguardedInitializationPolicy {

    override fun invoke(requestPolicy: RequestPolicy): RequestPolicy {
        val retryPolicy = requestPolicy.retryPolicy
        val timeoutPolicy = requestPolicy.timeoutPolicy

        return RequestPolicy.newBuilder(requestPolicy).setRetryPolicy(
                RequestRetryPolicy.newBuilder(retryPolicy).setMaxDuration(
                        maxOf(
                            SafeGuards.InitRequestRetryPolicy.MIN_DURATION, retryPolicy.maxDuration
                        )
                    ).setRetryWaitBase(
                        maxOf(
                            SafeGuards.InitRequestRetryPolicy.MIN_WAIT_BASE,
                            retryPolicy.retryWaitBase
                        )
                    ).setRetryMaxInterval(
                        maxOf(
                            SafeGuards.InitRequestRetryPolicy.MIN_MAX_INTERVAL,
                            retryPolicy.retryMaxInterval
                        )
                    ).setRetryScalingFactor(
                        maxOf(
                            SafeGuards.InitRequestRetryPolicy.MIN_SCALING_FACTOR,
                            retryPolicy.retryScalingFactor
                        )
                    ).setRetryJitterPct(
                        minOf(
                            SafeGuards.InitRequestRetryPolicy.MAX_JITTER_PCT, maxOf(
                                SafeGuards.InitRequestRetryPolicy.MIN_JITTER_PCT,
                                retryPolicy.retryJitterPct
                            )
                        )
                    )
            ).setTimeoutPolicy(
                RequestTimeoutPolicy.newBuilder(timeoutPolicy).setConnectTimeoutMs(
                        maxOf(
                            SafeGuards.InitRequestTimeoutPolicy.MIN_TIMEOUT,
                            timeoutPolicy.connectTimeoutMs
                        )
                    ).setReadTimeoutMs(
                        maxOf(
                            SafeGuards.InitRequestTimeoutPolicy.MIN_TIMEOUT,
                            timeoutPolicy.readTimeoutMs
                        )
                    ).setWriteTimeoutMs(
                        maxOf(
                            SafeGuards.InitRequestTimeoutPolicy.MIN_TIMEOUT,
                            timeoutPolicy.writeTimeoutMs
                        )
                    ).setOverallTimeoutMs(
                        maxOf(
                            SafeGuards.InitRequestTimeoutPolicy.MIN_TIMEOUT,
                            timeoutPolicy.overallTimeoutMs
                        )
                    )
            ).build()
    }
}