/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.domain;

import android.content.Context;
import android.net.Uri;
import android.webkit.WebResourceResponse;
import androidx.annotation.RequiresApi;
import com.unity3d.ads.core.data.model.CacheResult;
import com.unity3d.ads.core.data.repository.CacheRepository;
import com.unity3d.ads.core.domain.CacheWebViewAssets;
import com.unity3d.ads.core.extensions.StringExtensionsKt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\b\u0010\u000e\u001a\u00020\nH\u0003J\u001d\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0087\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/unity3d/ads/core/domain/GetCachedAsset;", "", "cacheRepository", "Lcom/unity3d/ads/core/data/repository/CacheRepository;", "context", "Landroid/content/Context;", "cacheWebViewAssets", "Lcom/unity3d/ads/core/domain/CacheWebViewAssets;", "(Lcom/unity3d/ads/core/data/repository/CacheRepository;Landroid/content/Context;Lcom/unity3d/ads/core/domain/CacheWebViewAssets;)V", "getBundledAsset", "Landroid/webkit/WebResourceResponse;", "uri", "Landroid/net/Uri;", "getCachedAsset", "getNotFoundResponse", "invoke", "webviewType", "", "tryGetWebViewAsset", "unity-ads_defaultRelease"})
@SourceDebugExtension(value={"SMAP\nGetCachedAsset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetCachedAsset.kt\ncom/unity3d/ads/core/domain/GetCachedAsset\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class GetCachedAsset {
    @NotNull
    private final CacheRepository cacheRepository;
    @NotNull
    private final Context context;
    @NotNull
    private final CacheWebViewAssets cacheWebViewAssets;

    public GetCachedAsset(@NotNull CacheRepository cacheRepository, @NotNull Context context, @NotNull CacheWebViewAssets cacheWebViewAssets) {
        Intrinsics.checkNotNullParameter((Object)cacheRepository, (String)"cacheRepository");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cacheWebViewAssets, (String)"cacheWebViewAssets");
        this.cacheRepository = cacheRepository;
        this.context = context;
        this.cacheWebViewAssets = cacheWebViewAssets;
    }

    @RequiresApi(value=21)
    private final WebResourceResponse getNotFoundResponse() {
        return new WebResourceResponse("text/html", "utf-8", 404, "Not Found", MapsKt.emptyMap(), (InputStream)new ByteArrayInputStream(new byte[0]));
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresApi(value=21)
    @Nullable
    public final WebResourceResponse invoke(@NotNull Uri uri, @NotNull String webviewType) {
        WebResourceResponse webResourceResponse;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)webviewType, (String)"webviewType");
        String string = uri.getHost();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -1920242293: {
                    if (!string.equals("unity.ads.cache")) break;
                    n = 1;
                    break;
                }
                case -1921537799: {
                    if (!string.equals("unity.ads.asset")) break;
                    n = 2;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    webResourceResponse = this.getCachedAsset(uri);
                    return webResourceResponse;
                }
                case 2: {
                    webResourceResponse = this.getBundledAsset(uri);
                    return webResourceResponse;
                }
            }
        }
        webResourceResponse = this.tryGetWebViewAsset(uri, webviewType);
        return webResourceResponse;
    }

    public static /* synthetic */ WebResourceResponse invoke$default(GetCachedAsset getCachedAsset2, Uri uri, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return getCachedAsset2.invoke(uri, string);
    }

    @RequiresApi(value=21)
    private final WebResourceResponse getBundledAsset(Uri uri) {
        WebResourceResponse webResourceResponse;
        String fileName = StringsKt.substringAfter$default((String)String.valueOf(uri.getPath()), (String)"/", null, (int)2, null);
        try {
            InputStream inputStream = this.context.getAssets().open(fileName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(fileName)");
            InputStream inputStream2 = inputStream;
            webResourceResponse = new WebResourceResponse(StringExtensionsKt.guessMimeType(fileName), null, inputStream2);
        }
        catch (Exception _) {
            return this.getNotFoundResponse();
        }
        return webResourceResponse;
    }

    @RequiresApi(value=21)
    private final WebResourceResponse getCachedAsset(Uri uri) {
        WebResourceResponse webResourceResponse;
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        String urlString = string;
        String fileName = StringsKt.substringAfterLast$default((String)urlString, (String)"/", null, (int)2, null);
        CacheResult result2 = (CacheResult)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CacheResult>, Object>(this, fileName, null){
            int label;
            final /* synthetic */ GetCachedAsset this$0;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$fileName = $fileName;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = GetCachedAsset.access$getCacheRepository$p(this.this$0).retrieveFile(this.$fileName, (Continuation<? super CacheResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CacheResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (result2 instanceof CacheResult.Success) {
            Object object;
            File file = ((CacheResult.Success)result2).getCachedFile().getFile();
            if (file == null) {
                return null;
            }
            File rawFile = file;
            Object object2 = this;
            try {
                GetCachedAsset $this$getCachedAsset_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)new FileInputStream(rawFile));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            FileInputStream fileInputStream = (FileInputStream)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (fileInputStream == null) {
                return null;
            }
            FileInputStream fileInputStream2 = fileInputStream;
            String filePath = rawFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
            webResourceResponse = new WebResourceResponse(StringExtensionsKt.guessMimeType(filePath), null, (InputStream)fileInputStream2);
        } else {
            webResourceResponse = this.getNotFoundResponse();
        }
        return webResourceResponse;
    }

    private final WebResourceResponse tryGetWebViewAsset(Uri uri, String webviewType) {
        WebResourceResponse webResourceResponse;
        StringBuilder stringBuilder = new StringBuilder().append(webviewType).append('/');
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        String filename = stringBuilder.append(StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)string, (String)"?", null, (int)2, null), (String)"/", null, (int)2, null)).toString();
        File file = this.cacheWebViewAssets.getCached().get(filename);
        if (file != null) {
            Object object;
            Object object2 = this;
            try {
                GetCachedAsset $this$tryGetWebViewAsset_u24lambda_u241 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)new FileInputStream(file));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            FileInputStream fileInputStream = (FileInputStream)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (fileInputStream == null) {
                return null;
            }
            FileInputStream fileInputStream2 = fileInputStream;
            webResourceResponse = new WebResourceResponse(StringExtensionsKt.guessMimeType(filename), null, (InputStream)fileInputStream2);
        } else {
            webResourceResponse = null;
        }
        return webResourceResponse;
    }

    public static final /* synthetic */ CacheRepository access$getCacheRepository$p(GetCachedAsset $this) {
        return $this.cacheRepository;
    }
}

