package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class PendingPurchasesParamsBuilderBridge(
    private val builderInstance: Any
) : GenericBridge(
    hashMapOf(
        ENABLE_ONE_TIME_PRODUCT_METHOD to emptyArray(),
        BUILD_METHOD to emptyArray()
    )
) {
    override fun getClassName(): String {
        // The class name for the Builder
        return "com.android.billingclient.api.PendingPurchasesParams\$Builder"
    }

    fun enableOneTimeProducts(): PendingPurchasesParamsBuilderBridge {
        callVoidMethod(ENABLE_ONE_TIME_PRODUCT_METHOD, builderInstance)
        return this // Return this for chaining, similar to the actual Builder
    }

    fun build(): PendingPurchasesParamsBridge { // build() returns PendingPurchasesParams
        val pendingPurchasesParams = callNonVoidMethod<Any>(BUILD_METHOD, builderInstance)
        return PendingPurchasesParamsBridge(pendingPurchasesParams)
    }

    companion object {
        private const val ENABLE_ONE_TIME_PRODUCT_METHOD = "enableOneTimeProducts"
        private const val BUILD_METHOD = "build"
    }
}