package com.unity3d.ads.core.domain.scar

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.core.domain.GetRequestPolicy
import com.unity3d.ads.core.domain.GetUniversalRequestForPayLoad
import com.unity3d.ads.core.domain.SendDiagnosticEvent
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.services.ads.gmascar.models.BiddingSignals
import gatewayprotocol.v1.UniversalRequestKt
import gatewayprotocol.v1.UniversalResponseOuterClass.UniversalResponse

class HandleAndroidGetTokenRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val getHbTokenEventRequest: GetHbTokenEventRequest,
    private val getRequestPolicy: GetRequestPolicy,
    private val gatewayClient: GatewayClient
): HandleGetTokenRequest {
    override suspend fun invoke(tokenId: ByteString, biddingSignals: BiddingSignals): UniversalResponse {
        val request = getHbTokenEventRequest(tokenId, biddingSignals)
        val payload = UniversalRequestKt.payload {
            getTokenEventRequest = request
        }
        val universalRequestData = getUniversalRequestForPayLoad(payload)
        val policy = getRequestPolicy()
        return gatewayClient.request(request = universalRequestData, requestPolicy = policy, operationType = OperationType.GET_TOKEN)
    }

}