package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.AdObject

interface AdRepository {
    fun addAd(opportunityId: ByteString, adObject: AdObject)
    fun getAd(opportunityId: ByteString): AdObject?
    fun pollOpportunityIdForPlacement(placementId: String): ByteString?
    fun enqueueOpportunityForPlacement(placementId: String, opportunityId: ByteString)
    fun removeAd(opportunityId: ByteString)
    fun hasOpportunityId(opportunityId: ByteString): Boolean
    fun getAllAds(): Map<ByteString, AdObject>
}