package com.unity3d.ads.core.data.datasource

import androidx.datastore.core.CorruptionException
import com.google.protobuf.ByteString
import com.unity3d.ads.datastore.UniversalRequestStoreOuterClass
import kotlinx.coroutines.flow.catch
import kotlinx.coroutines.flow.first

class UniversalRequestDataSource(
    private val universalRequestStoreProvider: UniversalRequestDataStoreProvider
) {
    suspend fun get(): UniversalRequestStoreOuterClass.UniversalRequestStore =
        universalRequestStoreProvider().data.catch { exception ->
            if (exception is CorruptionException) {
                emit(UniversalRequestStoreOuterClass.UniversalRequestStore.getDefaultInstance())
            } else {
                throw exception
            }
        }.first()

    suspend fun set(key: String, data: ByteString) {
        universalRequestStoreProvider().updateData { currentData ->
            val dataBuilder = currentData.toBuilder()
            dataBuilder.putUniversalRequestMap(key, data)
            dataBuilder.build()
        }
    }

    suspend fun remove(key: String) {
        universalRequestStoreProvider().updateData { currentData ->
            val dataBuilder = currentData.toBuilder()
            dataBuilder.removeUniversalRequestMap(key)
            dataBuilder.build()
        }
    }
}