package com.unity3d.ads.core.data.datasource

import android.content.Context

internal class AndroidUnityBootConfigDataSource(
    private val context: Context
) : UnityBootConfigDataSource {
    override fun getValue(key: String): String? {
        return runCatching {
            val prefix = "$key="
            var value: String? = null

            context.assets.open("bin/Data/boot.config").use { stream ->
                stream.bufferedReader().forEachLine { line ->
                    if (line.startsWith(prefix)) {
                        value = line.substring(prefix.length)
                    }
                }
            }
            value
        }.getOrNull()
    }
}
