/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.log;

import android.util.Log;
import com.unity3d.ads.core.data.repository.SessionRepository;
import com.unity3d.ads.core.domain.CreateFile;
import com.unity3d.ads.core.log.LogLevel;
import com.unity3d.ads.core.log.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u001a\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\u001a\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/unity3d/ads/core/log/UnityLogger;", "Lcom/unity3d/ads/core/log/Logger;", "sessionRepository", "Lcom/unity3d/ads/core/data/repository/SessionRepository;", "createFile", "Lcom/unity3d/ads/core/domain/CreateFile;", "(Lcom/unity3d/ads/core/data/repository/SessionRepository;Lcom/unity3d/ads/core/domain/CreateFile;)V", "isForced", "", "value", "Lcom/unity3d/ads/core/log/LogLevel;", "logLevel", "getLogLevel", "()Lcom/unity3d/ads/core/log/LogLevel;", "setLogLevel", "(Lcom/unity3d/ads/core/log/LogLevel;)V", "canLog", "targetLogLevel", "", "debug", "", "fb", "Lkotlin/Function0;", "", "message", "error", "e", "", "info", "trace", "Companion", "unity-ads_defaultRelease"})
public final class UnityLogger
implements Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LogLevel logLevel;
    private final boolean isForced;
    @NotNull
    private static final String LOG_TAG = "UnityAds";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnityLogger(@NotNull SessionRepository sessionRepository, @NotNull CreateFile createFile) {
        Intrinsics.checkNotNullParameter((Object)sessionRepository, (String)"sessionRepository");
        Intrinsics.checkNotNullParameter((Object)createFile, (String)"createFile");
        this.logLevel = LogLevel.INFO;
        File forceDebugFile = createFile.invoke("/data/local/tmp/UnityAdsForceDebugMode");
        try {
            boolean enableTracing = sessionRepository.getNativeConfiguration().getDebugSettings().getEnableTracing();
            if (forceDebugFile.exists() || enableTracing) {
                this.setLogLevel(LogLevel.TRACE);
                this.debug("Unity logger initialized in TRACE mode");
            }
            this.isForced = this.getLogLevel() == LogLevel.TRACE;
        }
        catch (Throwable _) {
            try {
                Log.w((String)LOG_TAG, (String)"An issue occurred while initializing the logger");
                this.isForced = this.getLogLevel() == LogLevel.TRACE;
            }
            catch (Throwable throwable) {
                this.isForced = this.getLogLevel() == LogLevel.TRACE;
                throw throwable;
            }
        }
    }

    @Override
    @NotNull
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(@NotNull LogLevel value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (!this.isForced) {
            this.logLevel = value;
        }
    }

    private final boolean canLog(int targetLogLevel) {
        return targetLogLevel >= this.getLogLevel().toAndroidLogLevel();
    }

    @Override
    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.canLog(4)) {
            return;
        }
        Log.i((String)LOG_TAG, (String)message);
    }

    @Override
    public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.canLog(3)) {
            return;
        }
        Log.d((String)LOG_TAG, (String)message);
    }

    @Override
    public void error(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.canLog(6)) {
            return;
        }
        Log.e((String)LOG_TAG, (String)message, (Throwable)e);
    }

    @Override
    public void trace(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!this.canLog(2)) {
            return;
        }
        Log.v((String)LOG_TAG, (String)message, (Throwable)e);
    }

    @Override
    public void debug(@NotNull Function0<String> fb) {
        Intrinsics.checkNotNullParameter(fb, (String)"fb");
        if (!this.canLog(3)) {
            return;
        }
        this.debug((String)fb.invoke());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unity3d/ads/core/log/UnityLogger$Companion;", "", "()V", "LOG_TAG", "", "unity-ads_defaultRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

