package com.unity3d.ads.core.configuration

import com.unity3d.services.core.misc.JsonStorage
import org.json.JSONObject

class MediationTraitsMetadataReader(
    jsonStorage: JsonStorage
) : MetadataReader<JSONObject>(jsonStorage, MEDIATION_TRAITS) {

    fun getBooleanTrait(key: String): Boolean? {
        return read<JSONObject?>()?.takeIf { it.has(key) }?.optBoolean(key)
    }

    fun getStringTrait(key: String): String? {
        return read<JSONObject?>()?.takeIf { it.has(key) }?.optString(key)
    }

    companion object {
        const val MEDIATION_TRAITS = "mediation.traits.value"
        const val BOLD_SDK_ENABLED = "boldSdkEnabled"
        const val USE_HTTP_CLIENT = "useHttpClient"
    }
}