package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class QueryProductDetailsParamsBuilderBridge(var builderInstance: Any): GenericBridge(
    mapOf(
        SET_PRODUCT_LIST_METHOD to arrayOf(List::class.java),
        BUILD_METHOD to emptyArray()
    )
) {
    override fun getClassName(): String {
        return "com.android.billingclient.api.QueryProductDetailsParams\$Builder"
    }

    fun build(): QueryProductDetailsParamsBridge {
        val queryProductDetailsParams = callNonVoidMethod<Any>(BUILD_METHOD, builderInstance)
        return QueryProductDetailsParamsBridge(queryProductDetailsParams)
    }

    fun setProductList(productList: List<ProductBridge>): QueryProductDetailsParamsBuilderBridge {
        val productListInternal = productList.map { it.getInternalClass() }
        builderInstance = callNonVoidMethod(SET_PRODUCT_LIST_METHOD, builderInstance, productListInternal)
        return this
    }

    companion object {
        private const val BUILD_METHOD = "build"
        private const val SET_PRODUCT_LIST_METHOD = "setProductList"
    }


}