package com.unity3d.ads.core.configuration
import android.content.Context
import android.content.pm.PackageManager

class AndroidManifestIntPropertyReader (
    private val context: Context
) {
    fun getPropertyByName(propertyName: String): Int? {
        return try {
            val applicationMetadata = context.packageManager.getApplicationInfo(context.packageName, PackageManager.GET_META_DATA).metaData
            applicationMetadata.getInt(propertyName).takeIf { applicationMetadata.containsKey(propertyName) }
        } catch (exception: Exception) {
            null
        }
    }
}