package com.unity3d.ads.core.configuration

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.core.configuration.ConfigurationReader
import kotlinx.coroutines.flow.MutableStateFlow
import org.json.JSONObject

class CommonAlternativeFlowReader(
    private val configurationReader: ConfigurationReader,
    private val sessionRepository: SessionRepository,
    private val mediationMetadataReader: MediationTraitsMetadataReader
) : AlternativeFlowReader {
    private val isAlternativeFlowRead = MutableStateFlow(false)
    private val isAlternativeFlowEnabled = MutableStateFlow(false)

    override operator fun invoke(): Boolean {
        // Early return if we already read the alternative flow value
        if (isAlternativeFlowRead.value) return isAlternativeFlowEnabled.value

        // Check in Mediation metadata if the alternative flow is enabled
        mediationMetadataReader.read<JSONObject?>()
            ?.takeIf {it.has(MediationTraitsMetadataReader.BOLD_SDK_ENABLED)}
            ?.let {
                isAlternativeFlowEnabled.value =
                    it.optBoolean(MediationTraitsMetadataReader.BOLD_SDK_ENABLED)
                isAlternativeFlowRead.value = true
        }

        // Check in the native configuration (for boldSdkNextSessionEnabled flag) unless its been read from elsewhere
        if (!isAlternativeFlowRead.value) {
            isAlternativeFlowEnabled.value =
                configurationReader.currentConfiguration.experiments.isBoldSdkNextSessionEnabled ||
                    sessionRepository.nativeConfiguration.featureFlags.boldSdkNextSessionEnabled
            isAlternativeFlowRead.value = true
        }
        return isAlternativeFlowEnabled.value
    }
}