package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.WebViewConfiguration
import java.io.File

/**
 * UseCase for caching WebView assets (entry point and additional files)
 */
interface CacheWebViewAssets {
    val cached: Map<String, File>

    /**
     * Caches the WebView assets from the provided WebViewConfiguration
     *
     * @param webviewConfiguration The WebView configuration containing the entry point and additional files to cache
     * @param type The type of WebView (e.g., "iAds", "uAds")
     */
    suspend operator fun invoke(webviewConfiguration: WebViewConfiguration)
}
