package com.unity3d.services.ads.gmascar.managers;

import com.unity3d.ads.IUnityAdsTokenListener;
import com.unity3d.ads.TokenConfiguration;
import com.unity3d.services.ads.gmascar.GMA;

import com.unity3d.services.ads.gmascar.utils.ScarAdFormatProvider;
import com.unity3d.services.core.configuration.IExperiments;

public class BiddingManagerFactory {

	private static BiddingManagerFactory instance;

	private BiddingManagerFactory() {}

	public static BiddingManagerFactory getInstance() {
		if (instance == null) {
			instance = new BiddingManagerFactory();
		}
		return instance;
	}

	public BiddingBaseManager createManager(IUnityAdsTokenListener unityAdsTokenListener,
											IExperiments experiments) {
		return createManager(unityAdsTokenListener, null, experiments);
	}

	public BiddingBaseManager createManager(IUnityAdsTokenListener unityAdsTokenListener,
											TokenConfiguration tokenConfiguration,
											IExperiments experiments) {
		if (GMA.getInstance().hasSCARBiddingSupport()) {
			return getExperiment(unityAdsTokenListener, tokenConfiguration, experiments);
		}

		return new BiddingDisabledManager(unityAdsTokenListener);
	}

	private BiddingBaseManager getExperiment(IUnityAdsTokenListener unityAdsTokenListener,
											 TokenConfiguration tokenConfiguration,
											 IExperiments experiments) {
		if (experiments == null || experiments.getScarBiddingManager() == null) {
			return new BiddingDisabledManager(unityAdsTokenListener);
		}

		String biddingManager = experiments.getScarBiddingManager();
		ScarBiddingManagerType biddingManagerType = ScarBiddingManagerType.fromName(biddingManager);
		ScarAdFormatProvider scarAdFormatProvider = new ScarAdFormatProvider(tokenConfiguration, experiments);

		switch (biddingManagerType) {
			case EAGER:
				return new BiddingEagerManager(scarAdFormatProvider, unityAdsTokenListener);
			case DISABLED:
			default:
				return new BiddingDisabledManager(unityAdsTokenListener);
		}
	}
}