/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.measurements;

import android.adservices.AdServicesState;
import android.adservices.measurement.MeasurementManager;
import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.OutcomeReceiver;
import android.os.ext.SdkExtensions;
import android.view.InputEvent;
import com.unity3d.services.ads.measurements.MeasurementsErrors;
import com.unity3d.services.ads.measurements.MeasurementsEvents;
import com.unity3d.services.ads.measurements.MeasurementsReceiver;
import com.unity3d.services.ads.measurements.MeasurementsStatusReceiver;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.domain.ISDKDispatchers;
import com.unity3d.services.core.webview.WebViewEventCategory;
import com.unity3d.services.core.webview.bridge.IEventSender;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/unity3d/services/ads/measurements/MeasurementsService;", "", "context", "Landroid/content/Context;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "eventSender", "Lcom/unity3d/services/core/webview/bridge/IEventSender;", "(Landroid/content/Context;Lcom/unity3d/services/core/domain/ISDKDispatchers;Lcom/unity3d/services/core/webview/bridge/IEventSender;)V", "measurementManager", "Landroid/adservices/measurement/MeasurementManager;", "checkAvailability", "", "getMeasurementManager", "registerClick", "url", "", "inputEvent", "Landroid/view/InputEvent;", "registerView", "unity-ads_release"})
@SuppressLint(value={"NewApi", "MissingPermission"})
public final class MeasurementsService {
    @NotNull
    private final ISDKDispatchers dispatchers;
    @NotNull
    private final IEventSender eventSender;
    @Nullable
    private final MeasurementManager measurementManager;

    public MeasurementsService(@NotNull Context context, @NotNull ISDKDispatchers dispatchers, @NotNull IEventSender eventSender) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dispatchers, (String)"dispatchers");
        Intrinsics.checkNotNullParameter((Object)eventSender, (String)"eventSender");
        this.dispatchers = dispatchers;
        this.eventSender = eventSender;
        this.measurementManager = this.getMeasurementManager(context);
    }

    public final void checkAvailability() {
        if (Device.getApiLevel() < 33) {
            Object[] objectArray = new Object[]{MeasurementsErrors.ERROR_API_BELOW_33};
            this.eventSender.sendEvent(WebViewEventCategory.MEASUREMENTS, MeasurementsEvents.NOT_AVAILABLE, objectArray);
            return;
        }
        if (SdkExtensions.getExtensionVersion((int)1000000) < 4) {
            Object[] objectArray = new Object[]{MeasurementsErrors.ERROR_EXTENSION_BELOW_4};
            this.eventSender.sendEvent(WebViewEventCategory.MEASUREMENTS, MeasurementsEvents.NOT_AVAILABLE, objectArray);
            return;
        }
        if (this.measurementManager == null) {
            Object[] objectArray = new Object[]{MeasurementsErrors.ERROR_MANAGER_NULL};
            this.eventSender.sendEvent(WebViewEventCategory.MEASUREMENTS, MeasurementsEvents.NOT_AVAILABLE, objectArray);
            return;
        }
        if (!AdServicesState.isAdServicesStateEnabled()) {
            Object[] objectArray = new Object[]{MeasurementsErrors.ERROR_AD_SERVICES_DISABLED};
            this.eventSender.sendEvent(WebViewEventCategory.MEASUREMENTS, MeasurementsEvents.NOT_AVAILABLE, objectArray);
            return;
        }
        this.measurementManager.getMeasurementApiStatus(ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getDefault()), (OutcomeReceiver)new MeasurementsStatusReceiver(this.eventSender));
    }

    public final void registerView(@NotNull String url) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            MeasurementManager measurementManager2 = this.measurementManager;
            if (measurementManager2 == null) break block0;
            measurementManager2.registerSource(Uri.parse((String)url), null, ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getDefault()), (OutcomeReceiver)new MeasurementsReceiver(this.eventSender, MeasurementsEvents.VIEW_SUCCESSFUL, MeasurementsEvents.VIEW_ERROR));
        }
    }

    public final void registerClick(@NotNull String url, @NotNull InputEvent inputEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"inputEvent");
            MeasurementManager measurementManager2 = this.measurementManager;
            if (measurementManager2 == null) break block0;
            measurementManager2.registerSource(Uri.parse((String)url), inputEvent, ExecutorsKt.asExecutor((CoroutineDispatcher)this.dispatchers.getDefault()), (OutcomeReceiver)new MeasurementsReceiver(this.eventSender, MeasurementsEvents.CLICK_SUCCESSFUL, MeasurementsEvents.CLICK_ERROR));
        }
    }

    private final MeasurementManager getMeasurementManager(Context context) {
        if (Device.getApiLevel() < 33) {
            return null;
        }
        if (SdkExtensions.getExtensionVersion((int)1000000) < 4) {
            return null;
        }
        return (MeasurementManager)context.getSystemService(MeasurementManager.class);
    }
}

