package com.unity3d.services.core.network.model

import com.unity3d.ads.core.data.model.exception.UnityAdsNetworkException

/**
 * Data class representing a generic http response
 */
data class HttpResponse @JvmOverloads constructor(
    val body: Any,
    val statusCode: Int = 200,
    val headers: Map<String, List<String>> = emptyMap(),
    val urlString: String = "",
    val protocol: String = "",
    val client: String = "unknown",
    val contentSize: Long = -1L
)

fun HttpResponse.isSuccessful(): Boolean = statusCode in 200..299

fun UnityAdsNetworkException.toHttpResponse(): HttpResponse = HttpResponse(
    body = "",
    statusCode = code ?: 520,
    headers = emptyMap(),
    urlString = url ?: "",
    protocol = protocol ?: "",
    client = client ?: "unknown"
)
