package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.LegacyUserConsentRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.core.device.StorageManager
import gatewayprotocol.v1.UniversalRequestKt.payload
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest
import gatewayprotocol.v1.initializationDeviceInfo
import gatewayprotocol.v1.initializationRequest



internal class GetAndroidInitializationRequest(
    private val getUniversalRequestForPayLoad: GetUniversalRequestForPayLoad,
    private val getClientInfo: GetClientInfo,
    private val sessionRepository: SessionRepository,
    private val deviceInfoRepository: DeviceInfoRepository,
    private val legacyUserConsentRepository: LegacyUserConsentRepository,
) : GetInitializationRequest {
    override suspend fun invoke(): UniversalRequest {
        val request = initializationRequest {
            isFirstInit = !StorageManager.getStorage(StorageManager.StorageType.PRIVATE).run {
                readStorage() && get("configuration.hasInitialized") as? Boolean ?: false
            }
            clientInfo = getClientInfo()
            idfi = deviceInfoRepository.getIdfi()
            deviceInfoRepository.analyticsUserId?.let { analyticsUserId = it }
            sessionId = sessionRepository.sessionId
            deviceInfo = initializationDeviceInfo {
                bundleId = deviceInfoRepository.appName
                deviceModel = deviceInfoRepository.model
                deviceMake = deviceInfoRepository.manufacturer
                osVersion = deviceInfoRepository.osVersion
            }

            val auidByteString = deviceInfoRepository.getAuidByteString()
            if (auidByteString != null) {
                this.auid = auidByteString
            }

            val auidString = deviceInfoRepository.getAuidString()
            if (!auidString.isNullOrEmpty()) {
                this.auidString = auidString
            }

            val privacy = sessionRepository.getPrivacy()
            if (!privacy.isEmpty) {
                this.privacy = privacy
            }

            val gatewayCache = sessionRepository.getGatewayCache()
            if (!gatewayCache.isEmpty) {
                cache = gatewayCache
            }

            legacyUserConsentRepository.legacyFlowUserConsent?.let { legacyFlowUserConsent = it }
        }
        val initPayload = payload {
            initializationRequest = request
        }
        return getUniversalRequestForPayLoad(initPayload)
    }
}
