package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.MediationRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.UnityAdsConstants
import gatewayprotocol.v1.ClientInfoOuterClass
import gatewayprotocol.v1.ClientInfoOuterClass.ClientInfo
import gatewayprotocol.v1.ClientInfoOuterClass.Platform
import gatewayprotocol.v1.clientInfo



internal class GetAndroidClientInfo(
    private val sessionRepository: SessionRepository,
    private val mediationRepository: MediationRepository
) : GetClientInfo {
    override fun invoke(): ClientInfo {
        return clientInfo {
            sdkVersion = UnityAdsConstants.ClientInfo.SDK_VERSION
            sdkVersionName = UnityAdsConstants.ClientInfo.SDK_VERSION_NAME
            gameId = sessionRepository.gameId
            test = sessionRepository.isTestModeEnabled
            platform = Platform.PLATFORM_ANDROID
            mediationProvider = mediationRepository.mediationProvider()
            mediationRepository.name?.let {
                if (mediationProvider == ClientInfoOuterClass.MediationProvider.MEDIATION_PROVIDER_CUSTOM) {
                    customMediationName = it
                }
            }
            mediationRepository.version?.let {
                mediationVersion = it
            }
        }
    }
}
