/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.data.datasource;

import android.content.Context;
import com.unity3d.ads.core.data.datasource.PrivacyDeviceInfoDataSource;
import com.unity3d.ads.core.extensions.ProtobufExtensionsKt;
import com.unity3d.services.core.device.AdvertisingId;
import com.unity3d.services.core.device.OpenAdvertisingId;
import gateway.v1.AllowedPiiOuterClass;
import gateway.v1.PiiKt;
import gateway.v1.PiiOuterClass;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unity3d/ads/core/data/datasource/AndroidPrivacyDeviceInfoDataSource;", "Lcom/unity3d/ads/core/data/datasource/PrivacyDeviceInfoDataSource;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "idfaInitialized", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "fetch", "Lgateway/v1/PiiOuterClass$Pii;", "allowed", "Lgateway/v1/AllowedPiiOuterClass$AllowedPii;", "getAdvertisingTrackingId", "", "getOpenAdvertisingTrackingId", "unity-ads_release"})
@SourceDebugExtension(value={"SMAP\nAndroidPrivacyDeviceInfoDataSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPrivacyDeviceInfoDataSource.kt\ncom/unity3d/ads/core/data/datasource/AndroidPrivacyDeviceInfoDataSource\n+ 2 PiiKt.kt\ngateway/v1/PiiKtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n8#2:46\n1#3:47\n*S KotlinDebug\n*F\n+ 1 AndroidPrivacyDeviceInfoDataSource.kt\ncom/unity3d/ads/core/data/datasource/AndroidPrivacyDeviceInfoDataSource\n*L\n28#1:46\n28#1:47\n*E\n"})
public final class AndroidPrivacyDeviceInfoDataSource
implements PrivacyDeviceInfoDataSource {
    @NotNull
    private final Context context;
    @NotNull
    private final MutableStateFlow<Boolean> idfaInitialized;

    public AndroidPrivacyDeviceInfoDataSource(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.idfaInitialized = StateFlowKt.MutableStateFlow((Object)false);
    }

    @Override
    @NotNull
    public PiiOuterClass.Pii fetch(@NotNull AllowedPiiOuterClass.AllowedPii allowed) {
        PiiKt.Dsl dsl;
        Intrinsics.checkNotNullParameter((Object)allowed, (String)"allowed");
        if (!((Boolean)this.idfaInitialized.getValue()).booleanValue()) {
            this.idfaInitialized.setValue((Object)true);
            AdvertisingId.init(this.context);
            OpenAdvertisingId.init(this.context);
        }
        boolean bl = false;
        PiiOuterClass.Pii.Builder builder = PiiOuterClass.Pii.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()");
        PiiKt.Dsl $this$pii_u24lambda_u240$iv = dsl = PiiKt.Dsl.Companion._create(builder);
        boolean bl2 = false;
        PiiKt.Dsl $this$fetch_u24lambda_u240 = $this$pii_u24lambda_u240$iv;
        boolean bl3 = false;
        if (allowed.getIdfa()) {
            String openAdId;
            String adId = this.getAdvertisingTrackingId();
            if (((CharSequence)adId).length() > 0) {
                UUID uUID = UUID.fromString(adId);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(adId)");
                $this$fetch_u24lambda_u240.setAdvertisingId(ProtobufExtensionsKt.toByteString(uUID));
            }
            if (((CharSequence)(openAdId = this.getOpenAdvertisingTrackingId())).length() > 0) {
                UUID uUID = UUID.fromString(openAdId);
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(openAdId)");
                $this$fetch_u24lambda_u240.setOpenAdvertisingTrackingId(ProtobufExtensionsKt.toByteString(uUID));
            }
        }
        return dsl._build();
    }

    private final String getAdvertisingTrackingId() {
        String string = AdvertisingId.getAdvertisingTrackingId();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final String getOpenAdvertisingTrackingId() {
        String string = OpenAdvertisingId.getOpenAdvertisingTrackingId();
        if (string == null) {
            string = "";
        }
        return string;
    }
}

