package com.unity3d.ads.core.data.repository

import gateway.v1.DiagnosticEventRequestOuterClass.DiagnosticEvent
import gateway.v1.NativeConfigurationOuterClass.DiagnosticEventsConfiguration
import kotlinx.coroutines.flow.SharedFlow

interface DiagnosticEventRepository {
    val diagnosticEvents: SharedFlow<List<DiagnosticEvent>>
    fun addDiagnosticEvent(diagnosticEvent: DiagnosticEvent)
    fun flush()
    fun clear()
    fun configure(diagnosticsEventsConfiguration: DiagnosticEventsConfiguration)
}