package com.unity3d.ads.core.domain.privacy

import com.unity3d.services.core.di.ServiceProvider.LEGACY_PRIVACY_RULES
import com.unity3d.services.core.misc.JsonFlattenerRules
import org.koin.core.annotation.Named
import org.koin.core.annotation.Single

@Single
@Named(LEGACY_PRIVACY_RULES)
class LegacyUserConsentFlattenerRulesUseCase : FlattenerRulesUseCase {
    override operator fun invoke() : JsonFlattenerRules {
        return JsonFlattenerRules(
            mutableListOf(
                "privacy",
                "unity",
                "pipl"
            ),
            listOf("value"),
            mutableListOf(
                "ts",
                "exclude",
                "pii",
                "nonBehavioral",
                "nonbehavioral"
            )
        )
    }
}