package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.services.core.properties.SdkProperties
import org.koin.core.annotation.Single
import java.util.*

@Single
internal class GetAndroidAdPlayerContext(
    private val deviceInfoRepository: DeviceInfoRepository,
    private val sessionRepository: SessionRepository,
) {
    suspend operator fun invoke(): Map<String, Any> {
        val staticDeviceInfo = deviceInfoRepository.staticDeviceInfo()
        val dynamicDeviceInfo = deviceInfoRepository.dynamicDeviceInfo

        return mapOf(
            "bundleId" to staticDeviceInfo.bundleId,
            "bundleVersion" to staticDeviceInfo.bundleVersion,
            "webviewHash" to "unknown",
            "sdkVersion" to SdkProperties.getVersionCode(),
            "sdkVersionName" to SdkProperties.getVersionName(),
            "osVersion" to staticDeviceInfo.osVersion,
            "systemLanguage" to Locale.getDefault().toString(),
            "deviceModel" to staticDeviceInfo.deviceModel,
            "limitAdTracking" to dynamicDeviceInfo.limitedTracking,
            "maxVolume" to dynamicDeviceInfo.android.maxVolume,
            KEY_GAME_ID to sessionRepository.gameId,
        )
    }

    companion object {
        const val KEY_GAME_ID = "gameId"
    }
}