package com.unity3d.ads.adplayer

import android.view.ViewGroup
import androidx.core.view.doOnAttach
import androidx.core.view.doOnDetach
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.extensions.toISO8859ByteString
import com.unity3d.ads.core.extensions.toUUID
import com.unity3d.services.UnityAdsConstants.OpenMeasurement.OM_SESSION_FINISH_DELAY_MS
import com.unity3d.services.banners.BannerViewCache
import com.unity3d.services.core.misc.ViewUtilities
import kotlinx.coroutines.*

internal class AndroidEmbeddableWebViewAdPlayer(
    private val webViewAdPlayer: WebViewAdPlayer,
    private val opportunityId: String,
    override val webViewContainer: AndroidWebViewContainer,
    private val openMeasurementRepository: OpenMeasurementRepository,
) : AdPlayer by webViewAdPlayer, EmbeddableAdPlayer {
    override fun show(showOptions: ShowOptions) {
        require(showOptions is AndroidShowOptions)
        val context = showOptions.context
        val bannerView = BannerViewCache.getInstance().getBannerView(opportunityId.toISO8859ByteString().toUUID().toString())

        MainScope().launch {
            webViewContainer.webView.layoutParams = ViewGroup.LayoutParams(
                ViewUtilities.pxFromDp(context, bannerView.size.width.toFloat()).toInt(),
                ViewUtilities.pxFromDp(context, bannerView.size.height.toFloat()).toInt(),
            )
        }

        webViewContainer.webView.doOnAttach {
            webViewAdPlayer.scope.launch {
                webViewAdPlayer.requestShow(showOptions.unityAdsShowOptions)
            }

            it.doOnDetach {
                webViewAdPlayer.scope.launch {
                    destroy()
                }
            }
        }

        MainScope().launch {
            bannerView.addView(webViewContainer.webView)
        }
    }

    override suspend fun destroy() {
        webViewAdPlayer.dispatchShowCompleted()

        // If the if had an OMID session we need to delay webview cleanup for 1 second.
        // https://interactiveadvertisingbureau.github.io/Open-Measurement-SDKAndroid/#9-stop-the-session
        if (openMeasurementRepository.hasSessionFinished(opportunityId.toISO8859ByteString())) {
            delay(OM_SESSION_FINISH_DELAY_MS)
        }
        // Destroy the webview container.
        webViewContainer.destroy()

        super<AdPlayer>.destroy()
    }
}