package com.unity3d.ads.core.domain.events

/**
 * This class is a container for the event observers.
 * Invocation starts observing for new events.
 */
class EventObservers(
    val operativeEventObserver: OperativeEventObserver,
    val diagnosticEventObserver: DiagnosticEventObserver
) {
    suspend operator fun invoke() {
        operativeEventObserver()
        diagnosticEventObserver()
    }
}