/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ConfigurationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.unity3d.services.core.device.AdvertisingId;
import com.unity3d.services.core.device.OpenAdvertisingId;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.preferences.AndroidPreferences;
import com.unity3d.services.core.properties.ClientProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class Device {
    public static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getModel() {
        return Build.MODEL;
    }

    public static int getScreenLayout() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getConfiguration().screenLayout;
        }
        return -1;
    }

    public static String getAdvertisingTrackingId() {
        return AdvertisingId.getAdvertisingTrackingId();
    }

    public static boolean isLimitAdTrackingEnabled() {
        return AdvertisingId.getLimitedAdTracking();
    }

    public static String getOpenAdvertisingTrackingId() {
        return OpenAdvertisingId.getOpenAdvertisingTrackingId();
    }

    public static boolean isLimitOpenAdTrackingEnabled() {
        return OpenAdvertisingId.getLimitedOpenAdTracking();
    }

    public static boolean isUsingWifi() {
        if (ClientProperties.getApplicationContext() != null) {
            ConnectivityManager mConnectivity = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
            if (mConnectivity == null) {
                return false;
            }
            TelephonyManager mTelephony = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            NetworkInfo info = mConnectivity.getActiveNetworkInfo();
            if (info == null || !mConnectivity.getBackgroundDataSetting() || !mConnectivity.getActiveNetworkInfo().isConnected() || mTelephony == null) {
                return false;
            }
            int netType = info.getType();
            return netType == 1 && info.isConnected();
        }
        return false;
    }

    public static String getIdfi() {
        String idfi = AndroidPreferences.getString("unityads-installinfo", "unityads-idfi");
        if (idfi == null) {
            idfi = Device.getUniqueEventId();
            AndroidPreferences.setString("unityads-installinfo", "unityads-idfi", idfi);
        }
        return idfi;
    }

    public static String getConnectionType() {
        String connectionType = Device.isUsingWifi() ? "wifi" : (Device.isActiveNetworkConnected() ? "cellular" : "none");
        return connectionType;
    }

    public static int getNetworkType() {
        if (ClientProperties.getApplicationContext() != null) {
            TelephonyManager tm = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            try {
                return tm.getNetworkType();
            }
            catch (SecurityException ex) {
                DeviceLog.warning("Unity Ads was not able to get current network type due to missing permission");
            }
        }
        return -1;
    }

    public static boolean getNetworkMetered() {
        if (ClientProperties.getApplicationContext() != null && Build.VERSION.SDK_INT >= 16) {
            ConnectivityManager mConnectivity = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity");
            if (mConnectivity == null) {
                return false;
            }
            return mConnectivity.isActiveNetworkMetered();
        }
        return false;
    }

    public static String getNetworkOperator() {
        if (ClientProperties.getApplicationContext() != null) {
            TelephonyManager tm = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            return tm.getNetworkOperator();
        }
        return "";
    }

    public static String getNetworkOperatorName() {
        if (ClientProperties.getApplicationContext() != null) {
            TelephonyManager tm = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            return tm.getNetworkOperatorName();
        }
        return "";
    }

    public static String getNetworkCountryISO() {
        if (ClientProperties.getApplicationContext() != null) {
            TelephonyManager tm = (TelephonyManager)ClientProperties.getApplicationContext().getSystemService("phone");
            return tm.getNetworkCountryIso();
        }
        return "";
    }

    public static float getDisplayMetricDensity() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().density;
        }
        return -1.0f;
    }

    public static int getScreenDensity() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().densityDpi;
        }
        return -1;
    }

    public static int getScreenWidth() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().widthPixels;
        }
        return -1;
    }

    public static int getScreenHeight() {
        if (ClientProperties.getApplicationContext() != null) {
            return ClientProperties.getApplicationContext().getResources().getDisplayMetrics().heightPixels;
        }
        return -1;
    }

    public static boolean isActiveNetworkConnected() {
        ConnectivityManager cm;
        if (ClientProperties.getApplicationContext() != null && (cm = (ConnectivityManager)ClientProperties.getApplicationContext().getSystemService("connectivity")) != null) {
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            return activeNetwork != null && activeNetwork.isConnected();
        }
        return false;
    }

    public static String getUniqueEventId() {
        return UUID.randomUUID().toString();
    }

    public static boolean isWiredHeadsetOn() {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager am = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            return am.isWiredHeadsetOn();
        }
        return false;
    }

    public static String getSystemProperty(String propertyName, String defaultValue) {
        if (defaultValue != null) {
            return System.getProperty(propertyName, defaultValue);
        }
        return System.getProperty(propertyName);
    }

    public static int getRingerMode() {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager am = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            if (am != null) {
                return am.getRingerMode();
            }
            return -2;
        }
        return -1;
    }

    public static int getStreamVolume(int streamType) {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager am = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            if (am != null) {
                return am.getStreamVolume(streamType);
            }
            return -2;
        }
        return -1;
    }

    public static int getStreamMaxVolume(int streamType) {
        if (ClientProperties.getApplicationContext() != null) {
            AudioManager am = (AudioManager)ClientProperties.getApplicationContext().getSystemService("audio");
            if (am != null) {
                return am.getStreamMaxVolume(streamType);
            }
            return -2;
        }
        return -1;
    }

    public static int getScreenBrightness() {
        if (ClientProperties.getApplicationContext() != null) {
            return Settings.System.getInt((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"screen_brightness", (int)-1);
        }
        return -1;
    }

    public static long getFreeSpace(File file) {
        if (file != null && file.exists()) {
            return Math.round(file.getFreeSpace() / 1024L);
        }
        return -1L;
    }

    public static long getTotalSpace(File file) {
        if (file != null && file.exists()) {
            return Math.round(file.getTotalSpace() / 1024L);
        }
        return -1L;
    }

    public static float getBatteryLevel() {
        Intent i;
        if (ClientProperties.getApplicationContext() != null && (i = ClientProperties.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            int level = i.getIntExtra("level", -1);
            int scale = i.getIntExtra("scale", -1);
            return (float)level / (float)scale;
        }
        return -1.0f;
    }

    public static int getBatteryStatus() {
        Intent i;
        if (ClientProperties.getApplicationContext() != null && (i = ClientProperties.getApplicationContext().registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"))) != null) {
            return i.getIntExtra("status", -1);
        }
        return -1;
    }

    public static long getTotalMemory() {
        return Device.getMemoryInfo(MemoryInfoType.TOTAL_MEMORY);
    }

    public static long getFreeMemory() {
        return Device.getMemoryInfo(MemoryInfoType.FREE_MEMORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getMemoryInfo(MemoryInfoType infoType) {
        int lineNumber = -1;
        switch (infoType) {
            case TOTAL_MEMORY: {
                lineNumber = 1;
                break;
            }
            case FREE_MEMORY: {
                lineNumber = 2;
                break;
            }
        }
        RandomAccessFile reader = null;
        String line = null;
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            for (int i = 0; i < lineNumber; ++i) {
                line = reader.readLine();
            }
            long i = Device.getMemoryValueFromString(line);
            return i;
        }
        catch (IOException e) {
            DeviceLog.exception("Error while reading memory info: " + (Object)((Object)infoType), e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                DeviceLog.exception("Error closing RandomAccessFile", e);
            }
        }
        return -1L;
    }

    private static long getMemoryValueFromString(String memVal) {
        if (memVal != null) {
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(memVal);
            String value = "";
            while (m.find()) {
                value = m.group(1);
            }
            return Long.parseLong(value);
        }
        return -1L;
    }

    public static boolean isRooted() {
        try {
            return Device.searchPathForBinary("su");
        }
        catch (Exception e) {
            DeviceLog.exception("Rooted check failed", e);
            return false;
        }
    }

    public static Boolean isAdbEnabled() {
        Boolean debugBridgeEnabled = null;
        debugBridgeEnabled = Device.getApiLevel() < 17 ? Device.oldAdbStatus() : Device.newAdbStatus();
        return debugBridgeEnabled;
    }

    private static Boolean oldAdbStatus() {
        Boolean status = null;
        try {
            status = 1 == Settings.Secure.getInt((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"adb_enabled", (int)0);
        }
        catch (Exception e) {
            DeviceLog.exception("Problems fetching adb enabled status", e);
        }
        return status;
    }

    @TargetApi(value=17)
    private static Boolean newAdbStatus() {
        Boolean status = null;
        try {
            status = 1 == Settings.Global.getInt((ContentResolver)ClientProperties.getApplicationContext().getContentResolver(), (String)"adb_enabled", (int)0);
        }
        catch (Exception e) {
            DeviceLog.exception("Problems fetching adb enabled status", e);
        }
        return status;
    }

    public static JSONObject getPackageInfo(PackageManager pm) throws PackageManager.NameNotFoundException, JSONException {
        String appName = ClientProperties.getAppName();
        PackageInfo appInfo = pm.getPackageInfo(appName, 0);
        JSONObject data = new JSONObject();
        data.put("installer", (Object)pm.getInstallerPackageName(appName));
        data.put("firstInstallTime", appInfo.firstInstallTime);
        data.put("lastUpdateTime", appInfo.lastUpdateTime);
        data.put("versionCode", appInfo.versionCode);
        data.put("versionName", (Object)appInfo.versionName);
        data.put("packageName", (Object)appInfo.packageName);
        return data;
    }

    private static boolean searchPathForBinary(String binary) {
        String[] paths;
        for (String path : paths = System.getenv("PATH").split(":")) {
            File[] pathDirFiles;
            File pathDir = new File(path);
            if (!pathDir.exists() || !pathDir.isDirectory() || (pathDirFiles = pathDir.listFiles()) == null) continue;
            for (File fileInPath : pathDirFiles) {
                if (!fileInPath.getName().equals(binary)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getGLVersion() {
        ConfigurationInfo configurationInfo;
        ActivityManager activityManager;
        if (ClientProperties.getApplicationContext() != null && (activityManager = (ActivityManager)ClientProperties.getApplicationContext().getSystemService("activity")) != null && (configurationInfo = activityManager.getDeviceConfigurationInfo()) != null) {
            return configurationInfo.getGlEsVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getApkDigest() throws Exception {
        String apkDigest = null;
        String apkPath = ClientProperties.getApplicationContext().getPackageCodePath();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(apkPath));
            apkDigest = Utilities.Sha256(inputStream);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return apkDigest;
    }

    public static String getCertificateFingerprint() {
        String fingerprint = null;
        PackageManager pm = ClientProperties.getApplicationContext().getPackageManager();
        String pkgName = ClientProperties.getApplicationContext().getPackageName();
        try {
            PackageInfo pinfo = pm.getPackageInfo(pkgName, 64);
            Signature[] signatures = pinfo.signatures;
            if (signatures != null && signatures.length >= 1) {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(signatures[0].toByteArray());
                X509Certificate cert = (X509Certificate)cf.generateCertificate(stream);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                byte[] publicKey = messageDigest.digest(cert.getEncoded());
                fingerprint = Utilities.toHexString(publicKey);
            }
        }
        catch (Exception e) {
            DeviceLog.exception("Exception when signing certificate fingerprint", e);
        }
        return fingerprint;
    }

    public static String getBoard() {
        return Build.BOARD;
    }

    public static String getBootloader() {
        return Build.BOOTLOADER;
    }

    public static String getBrand() {
        return Build.BRAND;
    }

    public static String getDevice() {
        return Build.DEVICE;
    }

    public static String getHardware() {
        return Build.HARDWARE;
    }

    public static String getHost() {
        return Build.HOST;
    }

    public static String getProduct() {
        return Build.PRODUCT;
    }

    public static String getFingerprint() {
        return Build.FINGERPRINT;
    }

    public static ArrayList<String> getSupportedAbis() {
        if (Device.getApiLevel() < 21) {
            return Device.getOldAbiList();
        }
        return Device.getNewAbiList();
    }

    public static List<Sensor> getSensorList() {
        if (ClientProperties.getApplicationContext() != null) {
            SensorManager sensorManager = (SensorManager)ClientProperties.getApplicationContext().getSystemService("sensor");
            return sensorManager.getSensorList(-1);
        }
        return null;
    }

    public static boolean isUSBConnected() {
        Intent intent;
        if (ClientProperties.getApplicationContext() != null && (intent = ClientProperties.getApplicationContext().registerReceiver(null, new IntentFilter("android.hardware.usb.action.USB_STATE"))) != null) {
            return intent.getBooleanExtra("connected", false);
        }
        return false;
    }

    public static long getCPUCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static long getUptime() {
        return SystemClock.uptimeMillis();
    }

    public static long getElapsedRealtime() {
        return SystemClock.elapsedRealtime();
    }

    public static String getBuildId() {
        return Build.ID;
    }

    public static String getBuildVersionIncremental() {
        return Build.VERSION.INCREMENTAL;
    }

    private static ArrayList<String> getOldAbiList() {
        ArrayList<String> abiList = new ArrayList<String>();
        abiList.add(Build.CPU_ABI);
        abiList.add(Build.CPU_ABI2);
        return abiList;
    }

    @TargetApi(value=21)
    private static ArrayList<String> getNewAbiList() {
        ArrayList<String> abiList = new ArrayList<String>();
        abiList.addAll(Arrays.asList(Build.SUPPORTED_ABIS));
        return abiList;
    }

    public static Map<String, String> getProcessInfo() {
        HashMap<String, String> retData = new HashMap<String, String>();
        RandomAccessFile reader = null;
        try {
            reader = new RandomAccessFile("/proc/self/stat", "r");
            String statContent = reader.readLine();
            retData.put("stat", statContent);
        }
        catch (IOException e) {
            DeviceLog.exception("Error while reading processor info: ", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                DeviceLog.exception("Error closing RandomAccessFile", e);
            }
        }
        return retData;
    }

    public static enum MemoryInfoType {
        TOTAL_MEMORY,
        FREE_MEMORY;

    }
}

