/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.analytics;

import com.unity3d.services.analytics.AcquisitionType;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.WebViewEventCategory;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class UnityAnalytics {
    protected static JSONArray eventQueue = new JSONArray();

    private static JSONObject createItemAcquired(String transactionContext, Float amount, String itemId, Float balance, String itemType, String level, String transactionId, AcquisitionType acquisitionType) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("currency_type", acquisitionType.toString());
        customParams.put("transaction_context", transactionContext);
        customParams.put("amount", amount);
        customParams.put("item_id", itemId);
        customParams.put("balance", balance);
        customParams.put("item_type", itemType);
        customParams.put("level", level);
        customParams.put("transaction_id", transactionId);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("custom_params", customParams);
        msg.put("ts", 1533594423477L);
        msg.put("name", "item_acquired");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "analytics.custom.v1");
        map.put("msg", msg);
        return new JSONObject(map);
    }

    private static JSONObject createItemSpent(String transactionContext, Float amount, String itemId, Float balance, String itemType, String level, String transactionId, AcquisitionType acquisitionType) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("currency_type", acquisitionType.toString());
        customParams.put("transaction_context", transactionContext);
        customParams.put("amount", amount);
        customParams.put("item_id", itemId);
        customParams.put("balance", balance);
        customParams.put("item_type", itemType);
        customParams.put("level", level);
        customParams.put("transaction_id", transactionId);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("custom_params", customParams);
        msg.put("ts", new Date().getTime());
        msg.put("name", "item_spent");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "analytics.custom.v1");
        map.put("msg", msg);
        return new JSONObject(map);
    }

    private static JSONObject createLevelFail(String levelIndex) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("level_index", levelIndex);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("custom_params", customParams);
        msg.put("ts", new Date().getTime());
        msg.put("name", "level_fail");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "analytics.custom.v1");
        map.put("msg", msg);
        return new JSONObject(map);
    }

    private static JSONObject createLevelUp(String newLevelIndex) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("new_level_index", newLevelIndex);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("custom_params", customParams);
        msg.put("ts", new Date().getTime());
        msg.put("name", "level_up");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "analytics.custom.v1");
        map.put("msg", msg);
        return new JSONObject(map);
    }

    private static JSONObject createAdComplete(String network, String placementId, Boolean rewarded) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("rewarded", rewarded);
        customParams.put("network", network);
        customParams.put("placement_id", placementId);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("custom_params", customParams);
        msg.put("ts", new Date().getTime());
        msg.put("name", "ad_complete");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "analytics.custom.v1");
        map.put("msg", msg);
        return new JSONObject(map);
    }

    private static JSONObject createIapTransaction(String productId, Float amount, String currency, Boolean isPromo, String receipt) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("ts", new Date().getTime());
        msg.put("productid", productId);
        msg.put("amount", amount);
        msg.put("currency", currency);
        msg.put("promo", isPromo);
        msg.put("receipt", receipt);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "analytics.transaction.v1");
        map.put("msg", msg);
        return new JSONObject(map);
    }

    public static void onItemAcquired(String transactionContext, Float amount, String itemId, Float balance, String itemType, String level, String transactionId, AcquisitionType acquisitionType) {
        JSONObject jsonObject = UnityAnalytics.createItemAcquired(transactionContext, amount, itemId, balance, itemType, level, transactionId, acquisitionType);
        UnityAnalytics.postEvent(jsonObject);
    }

    public static void onItemSpent(String transactionContext, Float amount, String itemId, Float balance, String itemType, String level, String transactionId, AcquisitionType acquisitionType) {
        JSONObject jsonObject = UnityAnalytics.createItemSpent(transactionContext, amount, itemId, balance, itemType, level, transactionId, acquisitionType);
        UnityAnalytics.postEvent(jsonObject);
    }

    public static void onLevelFail(String levelIndex) {
        JSONObject jsonObject = UnityAnalytics.createLevelFail(levelIndex);
        UnityAnalytics.postEvent(jsonObject);
    }

    public static void onLevelUp(String newLevelIndex) {
        JSONObject jsonObject = UnityAnalytics.createLevelUp(newLevelIndex);
        UnityAnalytics.postEvent(jsonObject);
    }

    public static void onAdComplete(String network, String placementId, Boolean rewarded) {
        JSONObject jsonObject = UnityAnalytics.createAdComplete(network, placementId, rewarded);
        UnityAnalytics.postEvent(jsonObject);
    }

    public static void onIapTransaction(String productId, Float amount, String currency, Boolean isPromo, String receipt) {
        JSONObject jsonObject = UnityAnalytics.createIapTransaction(productId, amount, currency, isPromo, receipt);
        UnityAnalytics.postEvent(jsonObject);
    }

    public static void onEvent(JSONObject jsonEvent) {
        UnityAnalytics.postEvent(jsonEvent);
    }

    private static synchronized void postEvent(JSONObject event) {
        Boolean success;
        WebViewApp currentApp;
        if (eventQueue.length() < 200) {
            eventQueue.put((Object)event);
        }
        if ((currentApp = WebViewApp.getCurrentApp()) != null && (success = Boolean.valueOf(currentApp.sendEvent(WebViewEventCategory.ANALYTICS, AnalyticsEventType.POSTEVENT, eventQueue.toString()))).booleanValue()) {
            eventQueue = new JSONArray();
        }
    }

    private static enum AnalyticsEventType {
        POSTEVENT;

    }
}

