/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import java.util.Iterator;
import java.util.Map;

public abstract class ResourceTrimmer {
    public ObjectNode trimObjectNode(ObjectNode objectNode) {
        return this.trimObjectNode(objectNode, Path.root());
    }

    private ObjectNode trimObjectNode(ObjectNode objectNode, Path parentPath) {
        ObjectNode objectToReturn = JsonUtils.getJsonNodeFactory().objectNode();
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            ArrayNode trimmedNode;
            Map.Entry field = (Map.Entry)i.next();
            Path path = parentPath.isRoot() && parentPath.getSchemaUrn() == null && SchemaUtils.isUrn((String)((String)field.getKey())) ? Path.root((String)((String)field.getKey())) : parentPath.attribute((String)field.getKey());
            if (!path.isRoot() && !this.shouldReturn(path)) continue;
            if (((JsonNode)field.getValue()).isArray()) {
                trimmedNode = this.trimArrayNode((ArrayNode)field.getValue(), path);
                if (trimmedNode.size() <= 0) continue;
                objectToReturn.set((String)field.getKey(), (JsonNode)trimmedNode);
                continue;
            }
            if (((JsonNode)field.getValue()).isObject()) {
                trimmedNode = this.trimObjectNode((ObjectNode)field.getValue(), path);
                if (trimmedNode.size() <= 0) continue;
                objectToReturn.set((String)field.getKey(), (JsonNode)trimmedNode);
                continue;
            }
            objectToReturn.set((String)field.getKey(), (JsonNode)field.getValue());
        }
        return objectToReturn;
    }

    protected ArrayNode trimArrayNode(ArrayNode arrayNode, Path parentPath) {
        ArrayNode arrayToReturn = JsonUtils.getJsonNodeFactory().arrayNode();
        for (JsonNode value : arrayNode) {
            ArrayNode trimmedNode;
            if (value.isArray()) {
                trimmedNode = this.trimArrayNode((ArrayNode)value, parentPath);
                if (trimmedNode.size() <= 0) continue;
                arrayToReturn.add((JsonNode)trimmedNode);
                continue;
            }
            if (value.isObject()) {
                trimmedNode = this.trimObjectNode((ObjectNode)value, parentPath);
                if (trimmedNode.size() <= 0) continue;
                arrayToReturn.add((JsonNode)trimmedNode);
                continue;
            }
            arrayToReturn.add(value);
        }
        return arrayToReturn;
    }

    public abstract boolean shouldReturn(Path var1);
}

