/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.utils.Debug;
import com.unboundid.scim2.common.utils.DebugType;
import com.unboundid.scim2.common.utils.FilterEvaluator;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaCheckFilterVisitor;
import java.net.URI;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class SchemaChecker {
    private final ResourceTypeDefinition resourceType;
    private final Collection<AttributeDefinition> commonAndCoreAttributes;
    private final Set<Option> enabledOptions;

    public SchemaChecker(ResourceTypeDefinition resourceType) {
        this.resourceType = resourceType;
        this.commonAndCoreAttributes = new LinkedHashSet<AttributeDefinition>(resourceType.getCoreSchema().getAttributes().size() + 4);
        this.commonAndCoreAttributes.addAll(SchemaUtils.COMMON_ATTRIBUTE_DEFINITIONS);
        this.commonAndCoreAttributes.addAll(resourceType.getCoreSchema().getAttributes());
        this.enabledOptions = new HashSet<Option>();
    }

    public void enable(Option option) {
        this.enabledOptions.add(option);
    }

    public void disable(Option option) {
        this.enabledOptions.remove((Object)option);
    }

    public Results checkCreate(ObjectNode objectNode) throws ScimException {
        ObjectNode copyNode = objectNode.deepCopy();
        Results results = new Results();
        this.checkResource("", copyNode, results, null, false);
        return results;
    }

    public Results checkModify(Iterable<PatchOperation> patchOperations, ObjectNode currentObjectNode) throws ScimException {
        ObjectNode copyCurrentNode = currentObjectNode == null ? null : currentObjectNode.deepCopy();
        ObjectNode appliedNode = currentObjectNode == null ? null : this.removeReadOnlyAttributes(currentObjectNode.deepCopy());
        Results results = new Results();
        int i = 0;
        block7: for (PatchOperation patchOp : patchOperations) {
            block17: {
                AttributeDefinition attribute;
                String prefix = "Patch op[" + i + "]: ";
                Path path = patchOp.getPath();
                JsonNode value = patchOp.getJsonNode();
                Filter valueFilter = path == null ? null : path.getElement(path.size() - 1).getValueFilter();
                AttributeDefinition attributeDefinition = attribute = path == null ? null : this.resourceType.getAttributeDefinition(path);
                if (path != null && attribute == null) {
                    this.addMessageForUndefinedAttr(path, prefix, results.pathIssues);
                    continue;
                }
                if (valueFilter != null && attribute != null && !attribute.isMultiValued()) {
                    results.pathIssues.add(prefix + "Attribute " + path.getElement(0) + " in path " + path.toString() + " must not have a value selection filter because it is not multi-valued");
                }
                if (valueFilter != null && attribute != null) {
                    SchemaCheckFilterVisitor.checkValueFilter(path.withoutFilters(), valueFilter, this.resourceType, this, this.enabledOptions, results);
                }
                switch (patchOp.getOpType()) {
                    case REMOVE: {
                        if (attribute == null) continue block7;
                        this.checkAttributeMutability(prefix, null, path, attribute, results, currentObjectNode, false, false, false);
                        if (valueFilter != null) break;
                        this.checkAttributeRequired(prefix, path, attribute, results);
                        break;
                    }
                    case REPLACE: {
                        if (attribute == null) {
                            this.checkPartialResource(prefix, (ObjectNode)value, results, copyCurrentNode, true, false);
                            break;
                        }
                        this.checkAttributeMutability(prefix, value, path, attribute, results, currentObjectNode, true, false, false);
                        if (valueFilter != null) {
                            this.checkAttributeValue(prefix, value, path, attribute, results, currentObjectNode, true, false);
                            break;
                        }
                        this.checkAttributeValues(prefix, value, path, attribute, results, copyCurrentNode, true, false);
                        break;
                    }
                    case ADD: {
                        if (attribute == null) {
                            this.checkPartialResource(prefix, (ObjectNode)value, results, copyCurrentNode, false, true);
                            break;
                        }
                        this.checkAttributeMutability(prefix, value, path, attribute, results, currentObjectNode, false, true, false);
                        if (valueFilter != null) {
                            this.checkAttributeValue(prefix, value, path, attribute, results, currentObjectNode, false, true);
                            break;
                        }
                        this.checkAttributeValues(prefix, value, path, attribute, results, copyCurrentNode, false, true);
                    }
                }
                if (appliedNode != null) {
                    try {
                        patchOp.apply(appliedNode);
                    }
                    catch (BadRequestException e) {
                        if (e.getScimError().getScimType().equals("noTarget")) break block17;
                        throw e;
                    }
                }
            }
            ++i;
        }
        if (appliedNode != null) {
            this.checkResource("Applying patch ops results in an invalid resource: ", appliedNode, results, copyCurrentNode, false);
        }
        return results;
    }

    public Results checkReplace(ObjectNode replacementObjectNode, ObjectNode currentObjectNode) throws ScimException {
        ObjectNode copyReplacementNode = replacementObjectNode.deepCopy();
        ObjectNode copyCurrentNode = currentObjectNode == null ? null : currentObjectNode.deepCopy();
        Results results = new Results();
        this.checkResource("", copyReplacementNode, results, copyCurrentNode, true);
        return results;
    }

    public ObjectNode removeReadOnlyAttributes(ObjectNode objectNode) {
        ObjectNode copyNode = objectNode.deepCopy();
        for (SchemaResource schemaExtension : this.resourceType.getSchemaExtensions().keySet()) {
            JsonNode extension = copyNode.get(schemaExtension.getId());
            if (extension == null || !extension.isObject()) continue;
            this.removeReadOnlyAttributes(schemaExtension.getAttributes(), (ObjectNode)extension);
        }
        this.removeReadOnlyAttributes(this.commonAndCoreAttributes, copyNode);
        return copyNode;
    }

    public Results checkSearch(Filter filter) throws ScimException {
        Results results = new Results();
        SchemaCheckFilterVisitor.checkFilter(filter, this.resourceType, this, this.enabledOptions, results);
        return results;
    }

    void addMessageForUndefinedAttr(Path path, String messagePrefix, List<String> messages) {
        if (path.size() > 1) {
            if (this.resourceType.getAttributeDefinition(path.subPath(1)) == null) {
                if (!this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_ATTRIBUTES)) {
                    messages.add(messagePrefix + "Attribute " + path.getElement(0) + " in path " + path.toString() + " is undefined");
                }
            } else if (!this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES)) {
                messages.add(messagePrefix + "Sub-attribute " + path.getElement(1) + " in path " + path.toString() + " is undefined");
            }
        } else if (!this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_ATTRIBUTES)) {
            messages.add(messagePrefix + "Attribute " + path.getElement(0) + " in path " + path.toString() + " is undefined");
        }
    }

    private void removeReadOnlyAttributes(Collection<AttributeDefinition> attributes, ObjectNode objectNode) {
        for (AttributeDefinition attribute : attributes) {
            if (attribute.getMutability() == AttributeDefinition.Mutability.READ_ONLY) {
                objectNode.remove(attribute.getName());
                continue;
            }
            if (attribute.getSubAttributes() == null) continue;
            JsonNode node = objectNode.path(attribute.getName());
            if (node.isObject()) {
                this.removeReadOnlyAttributes(attribute.getSubAttributes(), (ObjectNode)node);
                continue;
            }
            if (!node.isArray()) continue;
            for (JsonNode value : node) {
                if (!value.isObject()) continue;
                this.removeReadOnlyAttributes(attribute.getSubAttributes(), (ObjectNode)value);
            }
        }
    }

    private void checkPartialResource(String prefix, ObjectNode objectNode, Results results, ObjectNode currentObjectNode, boolean isPartialReplace, boolean isPartialAdd) throws ScimException {
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            if (!SchemaUtils.isUrn((String)((String)field.getKey()))) continue;
            if (!((JsonNode)field.getValue()).isObject()) {
                results.syntaxIssues.add(prefix + "Extended attributes namespace " + (String)field.getKey() + " must be a JSON object");
            } else {
                boolean found = false;
                for (SchemaResource schemaExtension : this.resourceType.getSchemaExtensions().keySet()) {
                    if (!schemaExtension.getId().equals(field.getKey())) continue;
                    this.checkObjectNode(prefix, Path.root((String)((String)field.getKey())), schemaExtension.getAttributes(), (ObjectNode)field.getValue(), results, currentObjectNode, isPartialReplace, isPartialAdd, false);
                    found = true;
                    break;
                }
                if (!found && !this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_ATTRIBUTES)) {
                    results.syntaxIssues.add(prefix + "Undefined extended attributes namespace " + field);
                }
            }
            i.remove();
        }
        this.checkObjectNode(prefix, Path.root(), this.commonAndCoreAttributes, objectNode, results, currentObjectNode, isPartialReplace, isPartialAdd, false);
    }

    private void checkResource(String prefix, ObjectNode objectNode, Results results, ObjectNode currentObjectNode, boolean isReplace) throws ScimException {
        JsonNode schemas = objectNode.get(SchemaUtils.SCHEMAS_ATTRIBUTE_DEFINITION.getName());
        if (schemas != null && schemas.isArray()) {
            boolean coreFound = false;
            for (JsonNode schema : schemas) {
                if (!schema.isTextual()) continue;
                JsonNode extensionNode = objectNode.remove(schema.textValue());
                if (extensionNode == null) {
                    extensionNode = JsonUtils.getJsonNodeFactory().objectNode();
                }
                if (!extensionNode.isObject()) {
                    results.syntaxIssues.add(prefix + "Extended attributes namespace " + schema.textValue() + " must be a JSON object");
                    continue;
                }
                Map.Entry<SchemaResource, Boolean> extensionDefinition = null;
                if (schema.textValue().equals(this.resourceType.getCoreSchema().getId())) {
                    coreFound = true;
                    continue;
                }
                for (Map.Entry<SchemaResource, Boolean> schemaExtension : this.resourceType.getSchemaExtensions().entrySet()) {
                    if (!schema.textValue().equals(schemaExtension.getKey().getId())) continue;
                    extensionDefinition = schemaExtension;
                    break;
                }
                if (extensionDefinition == null) continue;
                this.checkObjectNode(prefix, Path.root((String)schema.textValue()), ((SchemaResource)extensionDefinition.getKey()).getAttributes(), (ObjectNode)extensionNode, results, currentObjectNode, isReplace, false, isReplace);
            }
            if (!coreFound) {
                results.syntaxIssues.add(prefix + "Value for attribute schemas must  contain schema URI " + this.resourceType.getCoreSchema().getId() + " because it is the core schema for this resource type");
            }
            for (Map.Entry<SchemaResource, Boolean> schemaExtension : this.resourceType.getSchemaExtensions().entrySet()) {
                if (!schemaExtension.getValue().booleanValue()) continue;
                boolean found = false;
                for (JsonNode schema : schemas) {
                    if (!schema.textValue().equals(schemaExtension.getKey().getId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                results.syntaxIssues.add(prefix + "Value for attribute schemas must contain schema URI " + schemaExtension.getKey().getId() + " because it is a required schema extension for this resource type");
            }
        }
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            String fieldName = (String)((Map.Entry)i.next()).getKey();
            if (!SchemaUtils.isUrn((String)fieldName)) continue;
            results.syntaxIssues.add(prefix + "Extended attributes namespace " + fieldName + " must be included in the schemas attribute");
            i.remove();
        }
        this.checkObjectNode(prefix, Path.root(), this.commonAndCoreAttributes, objectNode, results, currentObjectNode, isReplace, false, isReplace);
    }

    private void checkAttributeMutability(String prefix, JsonNode node, Path path, AttributeDefinition attribute, Results results, ObjectNode currentObjectNode, boolean isPartialReplace, boolean isPartialAdd, boolean isReplace) throws ScimException {
        if (attribute.getMutability() == AttributeDefinition.Mutability.READ_ONLY) {
            results.mutabilityIssues.add(prefix + "Attribute " + path + " is read-only");
        }
        if (attribute.getMutability() == AttributeDefinition.Mutability.IMMUTABLE) {
            List currentValues;
            if (node == null) {
                results.mutabilityIssues.add(prefix + "Attribute " + path + " is immutable and value(s) may not be removed");
            }
            if (isPartialReplace && !isReplace) {
                results.mutabilityIssues.add(prefix + "Attribute " + path + " is immutable and value(s) may not be replaced");
            } else if (isPartialAdd && currentObjectNode != null && JsonUtils.pathExists((Path)path, (ObjectNode)currentObjectNode)) {
                results.mutabilityIssues.add(prefix + "Attribute " + path + " is immutable and value(s) may not be added");
            } else if (currentObjectNode != null && ((currentValues = JsonUtils.findMatchingPaths((Path)path, (ObjectNode)currentObjectNode)).size() > 1 || currentValues.size() == 1 && !((JsonNode)currentValues.get(0)).equals((Object)node))) {
                results.mutabilityIssues.add(prefix + "Attribute " + path + " is immutable and it already has a value");
            }
        }
        Filter valueFilter = path.getElement(path.size() - 1).getValueFilter();
        if (attribute.equals((Object)SchemaUtils.SCHEMAS_ATTRIBUTE_DEFINITION) && valueFilter != null) {
            if (FilterEvaluator.evaluate((Filter)valueFilter, (JsonNode)TextNode.valueOf((String)this.resourceType.getCoreSchema().getId()))) {
                results.syntaxIssues.add(prefix + "Attribute value(s) " + path + " may not be removed or replaced because the core schema " + this.resourceType.getCoreSchema().getId() + " is required for this resource type");
            }
            for (Map.Entry<SchemaResource, Boolean> schemaExtension : this.resourceType.getSchemaExtensions().entrySet()) {
                if (!schemaExtension.getValue().booleanValue() || !FilterEvaluator.evaluate((Filter)valueFilter, (JsonNode)TextNode.valueOf((String)schemaExtension.getKey().getId()))) continue;
                results.syntaxIssues.add(prefix + "Attribute value(s) " + path + " may not be removed or replaced because the schema extension " + schemaExtension.getKey().getId() + " is required for this resource type");
            }
        }
    }

    private void checkAttributeRequired(String prefix, Path path, AttributeDefinition attribute, Results results) {
        if (attribute.isRequired()) {
            results.syntaxIssues.add(prefix + "Attribute " + path + " is required and must have a value");
        }
    }

    private void checkAttributeValues(String prefix, JsonNode node, Path path, AttributeDefinition attribute, Results results, ObjectNode currentObjectNode, boolean isPartialReplace, boolean isPartialAdd) throws ScimException {
        if (attribute.isMultiValued() && !node.isArray()) {
            results.syntaxIssues.add(prefix + "Value for multi-valued attribute " + path + " must be a JSON array");
            return;
        }
        if (!attribute.isMultiValued() && node.isArray()) {
            results.syntaxIssues.add(prefix + "Value for single-valued attribute " + path + " must not be a JSON array");
            return;
        }
        if (node.isArray()) {
            int i = 0;
            for (JsonNode value : node) {
                if (path.isRoot()) {
                    throw new NullPointerException("Path should always point to an attribute");
                }
                Path parentPath = path.subPath(path.size() - 1);
                Path valuePath = parentPath.attribute(path.getElement(path.size() - 1).getAttribute() + "[" + i + "]");
                this.checkAttributeValue(prefix, value, valuePath, attribute, results, currentObjectNode, isPartialReplace, isPartialAdd);
                ++i;
            }
        } else {
            this.checkAttributeValue(prefix, node, path, attribute, results, currentObjectNode, isPartialReplace, isPartialAdd);
        }
    }

    private void checkAttributeValue(String prefix, JsonNode node, Path path, AttributeDefinition attribute, Results results, ObjectNode currentObjectNode, boolean isPartialReplace, boolean isPartialAdd) throws ScimException {
        if (node.isNull()) {
            return;
        }
        switch (attribute.getType()) {
            case STRING: 
            case DATETIME: 
            case REFERENCE: {
                if (node.isTextual()) break;
                results.syntaxIssues.add(prefix + "Value for attribute " + path + " must be a JSON string");
                return;
            }
            case BOOLEAN: {
                if (node.isBoolean()) break;
                results.syntaxIssues.add(prefix + "Value for attribute " + path + " must be a JSON boolean");
                return;
            }
            case DECIMAL: 
            case INTEGER: {
                if (node.isNumber()) break;
                results.syntaxIssues.add(prefix + "Value for attribute " + path + " must be a JSON number");
                return;
            }
            case COMPLEX: {
                if (node.isObject()) break;
                results.syntaxIssues.add(prefix + "Value for attribute " + path + " must be a JSON object");
                return;
            }
            case BINARY: {
                if (node.isTextual() || node.isBinary()) break;
                results.syntaxIssues.add(prefix + "Value for attribute " + path + " must be a JSON string");
                return;
            }
            default: {
                throw new RuntimeException("Unexpected attribute type " + attribute.getType());
            }
        }
        switch (attribute.getType()) {
            case DATETIME: {
                try {
                    ISO8601Utils.parse((String)node.textValue(), (ParsePosition)new ParsePosition(0));
                }
                catch (Exception e) {
                    Debug.debug((Level)Level.INFO, (DebugType)DebugType.EXCEPTION, (String)"Invalid ISO8601 string during schema checking", (Throwable)e);
                    results.syntaxIssues.add(prefix + "Value for attribute " + path + " is not a valid ISO8601 formatted string");
                }
                break;
            }
            case BINARY: {
                try {
                    node.binaryValue();
                }
                catch (Exception e) {
                    Debug.debug((Level)Level.INFO, (DebugType)DebugType.EXCEPTION, (String)"Invalid base64 string during schema checking", (Throwable)e);
                    results.syntaxIssues.add(prefix + "Value for attribute " + path + " is not a valid base64 encoded string");
                }
                break;
            }
            case REFERENCE: {
                try {
                    new URI(node.textValue());
                }
                catch (Exception e) {
                    Debug.debug((Level)Level.INFO, (DebugType)DebugType.EXCEPTION, (String)"Invalid URI string during schema checking", (Throwable)e);
                    results.syntaxIssues.add(prefix + "Value for attribute " + path + " is not a valid URI string");
                }
                break;
            }
            case INTEGER: {
                if (node.isIntegralNumber()) break;
                results.syntaxIssues.add(prefix + "Value for attribute " + path + " is not an integral number");
                break;
            }
            case COMPLEX: {
                this.checkObjectNode(prefix, path, attribute.getSubAttributes(), (ObjectNode)node, results, currentObjectNode, isPartialReplace, isPartialAdd, false);
                break;
            }
            case STRING: {
                if (attribute.getCanonicalValues() == null) break;
                boolean found = false;
                for (String canonicalValue : attribute.getCanonicalValues()) {
                    if (!(attribute.isCaseExact() ? canonicalValue.equals(node.textValue()) : StaticUtils.toLowerCase((String)canonicalValue).equals(StaticUtils.toLowerCase((String)node.textValue())))) continue;
                    found = true;
                    break;
                }
                if (found) break;
                results.syntaxIssues.add(prefix + "Value " + node.textValue() + " is not valid for attribute " + path + " because it is not one of the canonical types: " + StaticUtils.collectionToString((Collection)attribute.getCanonicalValues(), (String)", "));
            }
        }
        if (attribute.equals((Object)SchemaUtils.SCHEMAS_ATTRIBUTE_DEFINITION) && path.size() == 1) {
            boolean found = false;
            for (SchemaResource schemaExtension : this.resourceType.getSchemaExtensions().keySet()) {
                if (!node.textValue().equals(schemaExtension.getId())) continue;
                found = true;
                break;
            }
            if (!found) {
                found = node.textValue().equals(this.resourceType.getCoreSchema().getId());
            }
            if (!found && !this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_ATTRIBUTES)) {
                results.syntaxIssues.add(prefix + "Schema URI " + node.textValue() + " is not a valid value for attribute " + path + " because it is undefined as a core or schema extension for this resource type");
            }
        }
    }

    private void checkObjectNode(String prefix, Path parentPath, Collection<AttributeDefinition> attributes, ObjectNode objectNode, Results results, ObjectNode currentObjectNode, boolean isPartialReplace, boolean isPartialAdd, boolean isReplace) throws ScimException {
        if (attributes == null) {
            return;
        }
        for (AttributeDefinition attribute : attributes) {
            JsonNode node = objectNode.remove(attribute.getName());
            Path path = parentPath.attribute(attribute.getName());
            if ((node == null || node.isNull() || node.isArray() && node.size() == 0) && !isPartialAdd && !isPartialReplace) {
                this.checkAttributeRequired(prefix, path, attribute, results);
            }
            if (node == null) continue;
            this.checkAttributeMutability(prefix, node, path, attribute, results, currentObjectNode, isPartialReplace, isPartialAdd, isReplace);
            this.checkAttributeValues(prefix, node, path, attribute, results, currentObjectNode, isPartialReplace, isPartialAdd);
        }
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            String undefinedAttribute = (String)((Map.Entry)i.next()).getKey();
            if (parentPath.size() == 0) {
                if (!this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_ATTRIBUTES)) {
                    results.syntaxIssues.add(prefix + "Core attribute " + undefinedAttribute + " is undefined for schema " + this.resourceType.getCoreSchema().getId());
                }
            } else if (parentPath.isRoot() && parentPath.getSchemaUrn() != null) {
                if (!this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_ATTRIBUTES)) {
                    results.syntaxIssues.add(prefix + "Extended attribute " + undefinedAttribute + " is undefined for schema " + parentPath.getSchemaUrn());
                }
            } else if (!this.enabledOptions.contains((Object)Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES)) {
                results.syntaxIssues.add(prefix + "Sub-attribute " + undefinedAttribute + " is undefined for attribute " + parentPath);
            }
            i.remove();
        }
    }

    public static enum Option {
        ALLOW_UNDEFINED_ATTRIBUTES,
        ALLOW_UNDEFINED_SUB_ATTRIBUTES;

    }

    public static class Results {
        private final List<String> syntaxIssues = new LinkedList<String>();
        private final List<String> mutabilityIssues = new LinkedList<String>();
        private final List<String> pathIssues = new LinkedList<String>();
        private final List<String> filterIssues = new LinkedList<String>();

        void addFilterIssue(String issue) {
            this.filterIssues.add(issue);
        }

        public List<String> getSyntaxIssues() {
            return Collections.unmodifiableList(this.syntaxIssues);
        }

        public List<String> getMutabilityIssues() {
            return Collections.unmodifiableList(this.mutabilityIssues);
        }

        public List<String> getPathIssues() {
            return Collections.unmodifiableList(this.pathIssues);
        }

        public List<String> getFilterIssues() {
            return Collections.unmodifiableList(this.filterIssues);
        }

        public void throwSchemaExceptions() throws BadRequestException {
            if (this.syntaxIssues.size() > 0) {
                throw BadRequestException.invalidSyntax((String)this.getErrorString(this.syntaxIssues));
            }
            if (this.mutabilityIssues.size() > 0) {
                throw BadRequestException.mutability((String)this.getErrorString(this.mutabilityIssues));
            }
            if (this.pathIssues.size() > 0) {
                throw BadRequestException.invalidPath((String)this.getErrorString(this.pathIssues));
            }
            if (this.filterIssues.size() > 0) {
                throw BadRequestException.invalidFilter((String)this.getErrorString(this.filterIssues));
            }
        }

        private String getErrorString(List<String> issues) {
            if (issues == null || issues.isEmpty()) {
                return null;
            }
            return StaticUtils.collectionToString(issues, (String)", ");
        }
    }
}

