/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.providers;

import com.unboundid.scim2.common.exceptions.NotImplementedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.server.utils.ServerUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
@Priority(value=3000)
public class AuthenticatedSubjectAliasFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String requestPath = requestContext.getUriInfo().getPath();
        for (String alias : this.getAliases()) {
            if (!requestPath.startsWith(alias + "/") && !requestPath.equals(alias)) continue;
            try {
                String authSubjectPath = this.getAuthenticatedSubjectPath(requestContext.getSecurityContext());
                UriBuilder newRequestUri = requestContext.getUriInfo().getBaseUriBuilder();
                newRequestUri.path(authSubjectPath + requestPath.substring(alias.length()));
                MultivaluedMap queryParams = requestContext.getUriInfo().getQueryParameters();
                for (String key : queryParams.keySet()) {
                    List values = (List)queryParams.get((Object)key);
                    newRequestUri.queryParam(key, values.toArray());
                }
                requestContext.setRequestUri(newRequestUri.build(new Object[0]));
            }
            catch (ScimException e) {
                requestContext.abortWith(ServerUtils.setAcceptableType(Response.status((int)e.getScimError().getStatus()).entity((Object)e.getScimError()), requestContext.getAcceptableMediaTypes()).build());
            }
            break;
        }
    }

    protected String getAuthenticatedSubjectPath(SecurityContext securityContext) throws ScimException {
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw new NotImplementedException("/Me not supported");
        }
        return "Users/" + securityContext.getUserPrincipal().toString();
    }

    protected Collection<String> getAliases() {
        return Collections.singleton("Me");
    }
}

